/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.utils.codec.CodecUtils;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import it.unimi.dsi.fastutil.doubles.DoubleDoublePair;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class ResearchProgress {
    public static final Codec<ResearchProgress> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Task.CODEC.listOf().fieldOf("tasks").forGetter(ResearchProgress::tasks), (App)Type.CODEC.fieldOf("type").forGetter(ResearchProgress::type)).apply((Applicative)inst, ResearchProgress::new));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, ResearchProgress> STREAM_CODEC = StreamCodec.composite((StreamCodec)Task.STREAM_CODEC.apply(ByteBufCodecs.list()), ResearchProgress::tasks, Type.STREAM_CODEC, ResearchProgress::type, ResearchProgress::new);
    private final List<Task> tasks;
    private final Type type;

    public ResearchProgress(List<Task> tasks, Type type) {
        this.tasks = tasks;
        this.type = type;
    }

    public boolean isComplete() {
        return this.type.isComplete(this.tasks);
    }

    public float getProgress() {
        return this.type.getProgress(this.tasks);
    }

    public float getMaxProgress() {
        return this.type.getMaxProgress(this.tasks);
    }

    public void checkProgress(ResourceKey<Research> research, Level level, ResearchMethod.MethodContext context) {
        this.type.checkProgress(research, level, this.tasks, context);
    }

    @Nullable
    public Task getTask(ResearchMethod method) {
        for (Task task : this.tasks) {
            if (!task.method.equals(method)) continue;
            return task;
        }
        return null;
    }

    public static ResearchProgress forResearch(ResourceKey<Research> key, Level level) {
        Research research = ResearchHelperCommon.getResearch(key, level);
        ResearchMethod method = research.researchMethod();
        return method.createProgress();
    }

    public static ResearchProgress single(ResearchMethod method) {
        return new ResearchProgress(Collections.singletonList(new Task(method)), Type.SINGLE);
    }

    public static ResearchProgress and(List<ResearchMethod> methods) {
        return new ResearchProgress(methods.stream().map(Task::new).toList(), Type.AND);
    }

    public static ResearchProgress or(List<ResearchMethod> methods) {
        return new ResearchProgress(methods.stream().map(Task::new).toList(), Type.OR);
    }

    public List<Task> tasks() {
        return this.tasks;
    }

    public Type type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResearchProgress that = (ResearchProgress)obj;
        return Objects.equals(this.tasks, that.tasks) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tasks, this.type});
    }

    public String toString() {
        return "ResearchProgress[tasks=" + String.valueOf(this.tasks) + ", type=" + String.valueOf((Object)this.type) + "]";
    }

    public static enum Type implements StringRepresentable
    {
        OR("or"),
        AND("and"),
        SINGLE("single");

        public static final Codec<Type> CODEC;
        public static final StreamCodec<? super RegistryFriendlyByteBuf, Type> STREAM_CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public void checkProgress(ResourceKey<Research> research, Level level, List<Task> tasks, ResearchMethod.MethodContext context) {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    for (Task task : tasks) {
                        task.checkProgress(research, level, context);
                    }
                    break;
                }
                case 2: {
                    tasks.getFirst().checkProgress(research, level, context);
                }
            }
        }

        public boolean isComplete(List<Task> tasks) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> tasks.stream().anyMatch(Task::isComplete);
                case 1 -> tasks.stream().allMatch(Task::isComplete);
                case 2 -> tasks.getFirst().isComplete();
            };
        }

        public float getProgress(List<Task> tasks) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (float)this.getProgresses(tasks).firstDouble();
                case 1 -> (float)tasks.stream().mapToDouble(Task::getProgress).sum();
                case 2 -> tasks.getFirst().getProgress();
            };
        }

        public float getMaxProgress(List<Task> tasks) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (float)this.getProgresses(tasks).secondDouble();
                case 1 -> (float)tasks.stream().mapToDouble(Task::getMaxProgress).sum();
                case 2 -> tasks.getFirst().getMaxProgress();
            };
        }

        private DoubleDoublePair getProgresses(List<Task> tasks) {
            double curProgress = 0.0;
            double curMaxProgress = 0.0;
            for (Task task : tasks) {
                if (curMaxProgress != 0.0 && !((double)(task.getProgress() / task.getMaxProgress()) > curProgress / curMaxProgress)) continue;
                curProgress = task.getProgress();
                curMaxProgress = task.getMaxProgress();
            }
            return DoubleDoublePair.of((double)curProgress, (double)curMaxProgress);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            STREAM_CODEC = CodecUtils.enumStreamCodec(Type.class);
        }
    }

    public static class Task {
        public static final Codec<Task> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResearchMethod.CODEC.fieldOf("method").forGetter(Task::getMethod), (App)Codec.FLOAT.fieldOf("progress").forGetter(Task::getProgress), (App)Codec.FLOAT.fieldOf("max_progress").forGetter(Task::getMaxProgress)).apply((Applicative)inst, Task::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Task> STREAM_CODEC = StreamCodec.composite(ResearchMethod.STREAM_CODEC, Task::getMethod, (StreamCodec)ByteBufCodecs.FLOAT, Task::getProgress, (StreamCodec)ByteBufCodecs.FLOAT, Task::getMaxProgress, Task::new);
        private final ResearchMethod method;
        private float progress;
        private final float maxProgress;

        public Task(ResearchMethod method) {
            this(method, 0.0f, method.getMaxProgress());
        }

        public Task(ResearchMethod method, float maxProgress) {
            this(method, 0.0f, maxProgress);
        }

        public Task(ResearchMethod method, float progress, float maxProgress) {
            this.method = method;
            this.progress = progress;
            this.maxProgress = maxProgress;
        }

        public ResearchMethod getMethod() {
            return this.method;
        }

        public float getProgress() {
            return this.progress;
        }

        public float getMaxProgress() {
            return this.maxProgress;
        }

        public boolean isComplete() {
            return this.progress >= this.maxProgress;
        }

        public void addProgress(float progress) {
            this.progress = this.progress + progress > this.maxProgress ? this.maxProgress : (this.progress += progress);
        }

        public void checkProgress(ResourceKey<Research> research, Level level, ResearchMethod.MethodContext context) {
            if (!this.isComplete()) {
                this.method.checkProgress(level, research, this, context);
            }
        }
    }
}

