/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchSerializer;
import com.portingdeadmods.researchd.impl.research.ItemResearchIcon;
import com.portingdeadmods.researchd.impl.research.effect.EmptyResearchEffect;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public final class SimpleResearch
extends Record
implements Research {
    private final ItemResearchIcon researchIcon;
    private final ResearchMethod researchMethod;
    private final ResearchEffect researchEffect;
    private final List<ResourceKey<Research>> parents;
    private final boolean requiresParent;
    private final Optional<String> literalName;
    private final Optional<String> literalDescription;

    public SimpleResearch(ItemResearchIcon researchIcon, ResearchMethod researchMethod, ResearchEffect researchEffect, List<ResourceKey<Research>> parents, boolean requiresParent, Optional<String> literalName, Optional<String> literalDescription) {
        Researchd.LOGGER.debug("Creating simple research");
        this.researchIcon = researchIcon;
        this.researchMethod = researchMethod;
        this.researchEffect = researchEffect;
        this.parents = parents;
        this.requiresParent = requiresParent;
        this.literalName = literalName;
        this.literalDescription = literalDescription;
    }

    @Override
    public ResearchSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Optional<String> optional;
        boolean bl;
        ItemResearchIcon icon1;
        List<ResourceKey<Research>> list;
        if (!(o instanceof SimpleResearch)) return false;
        SimpleResearch simpleResearch = (SimpleResearch)o;
        try {
            list = simpleResearch.researchIcon();
            icon1 = list;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        List<ResourceKey<Research>> method = list = simpleResearch.researchMethod();
        List<ResourceKey<Research>> effect = list = simpleResearch.researchEffect();
        List<ResourceKey<Research>> parents1 = list = simpleResearch.parents();
        boolean parent = bl = simpleResearch.requiresParent();
        Optional<String> name = optional = simpleResearch.literalName();
        Optional<String> desc = optional = simpleResearch.literalDescription();
        if (this.requiresParent != parent) return false;
        if (!Objects.equals(this.researchIcon, icon1)) return false;
        if (!Objects.equals(this.researchMethod, method)) return false;
        if (!Objects.equals(this.researchEffect, effect)) return false;
        if (!Objects.equals(this.parents, parents1)) return false;
        if (!Objects.equals(this.literalName, name)) return false;
        if (!Objects.equals(this.literalDescription, desc)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.researchIcon, this.researchMethod, this.researchEffect, this.parents, this.requiresParent, this.literalName, this.literalDescription);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleResearch.class, "researchIcon;researchMethod;researchEffect;parents;requiresParent;literalName;literalDescription", "researchIcon", "researchMethod", "researchEffect", "parents", "requiresParent", "literalName", "literalDescription"}, this);
    }

    @Override
    public ItemResearchIcon researchIcon() {
        return this.researchIcon;
    }

    @Override
    public ResearchMethod researchMethod() {
        return this.researchMethod;
    }

    @Override
    public ResearchEffect researchEffect() {
        return this.researchEffect;
    }

    @Override
    public List<ResourceKey<Research>> parents() {
        return this.parents;
    }

    @Override
    public boolean requiresParent() {
        return this.requiresParent;
    }

    public Optional<String> literalName() {
        return this.literalName;
    }

    public Optional<String> literalDescription() {
        return this.literalDescription;
    }

    public static class Serializer
    implements ResearchSerializer<SimpleResearch> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<SimpleResearch> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemResearchIcon.CODEC.fieldOf("icon").forGetter(SimpleResearch::researchIcon), (App)ResearchMethod.CODEC.fieldOf("method").forGetter(SimpleResearch::researchMethod), (App)ResearchEffect.CODEC.optionalFieldOf("effect", (Object)EmptyResearchEffect.INSTANCE).forGetter(SimpleResearch::researchEffect), (App)Research.RESOURCE_KEY_CODEC.listOf().fieldOf("parents").forGetter(SimpleResearch::parents), (App)Codec.BOOL.fieldOf("requires_parent").forGetter(SimpleResearch::requiresParent), (App)Codec.STRING.optionalFieldOf("literal_name").forGetter(SimpleResearch::literalName), (App)Codec.STRING.optionalFieldOf("literal_description").forGetter(SimpleResearch::literalDescription)).apply((Applicative)instance, SimpleResearch::new));
        public static final StreamCodec<? super RegistryFriendlyByteBuf, SimpleResearch> STREAM_CODEC = NeoForgeStreamCodecs.composite(ItemResearchIcon.STREAM_CODEC, SimpleResearch::researchIcon, ResearchMethod.STREAM_CODEC, SimpleResearch::researchMethod, ResearchEffect.STREAM_CODEC, SimpleResearch::researchEffect, (StreamCodec)Research.RESOURCE_KEY_STREAM_CODEC.apply(ByteBufCodecs.list()), SimpleResearch::parents, (StreamCodec)ByteBufCodecs.BOOL, SimpleResearch::requiresParent, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), SimpleResearch::literalName, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), SimpleResearch::literalDescription, SimpleResearch::new);

        private Serializer() {
        }

        @Override
        public MapCodec<SimpleResearch> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, SimpleResearch> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Builder {
        private ItemResearchIcon icon = ItemResearchIcon.EMPTY;
        private ResearchMethod researchMethod;
        private ResearchEffect researchEffect = EmptyResearchEffect.INSTANCE;
        private final UniqueArray<ResourceKey<Research>> parents = new UniqueArray();
        private boolean requiresParent = false;
        private Optional<String> literalName = Optional.empty();
        private Optional<String> literalDescription = Optional.empty();

        private Builder() {
        }

        public Builder icon(Item icon) {
            this.icon = ItemResearchIcon.single((ItemLike)icon);
            return this;
        }

        public Builder icon(ItemResearchIcon icon) {
            this.icon = icon;
            return this;
        }

        public Builder method(ResearchMethod researchMethod) {
            this.researchMethod = researchMethod;
            return this;
        }

        public Builder effect(ResearchEffect researchEffect) {
            this.researchEffect = researchEffect;
            return this;
        }

        @SafeVarargs
        public final Builder parents(ResourceKey<Research> ... parents) {
            this.parents.addAll(List.of(parents));
            return this;
        }

        public Builder requiresParent(boolean requiresParent) {
            this.requiresParent = requiresParent;
            return this;
        }

        public Builder literalName(String name) {
            this.literalName = Optional.of(name);
            return this;
        }

        public Builder literalDescription(String description) {
            this.literalDescription = Optional.of(description);
            return this;
        }

        public SimpleResearch build() {
            return new SimpleResearch(this.icon, this.researchMethod, this.researchEffect, (List<ResourceKey<Research>>)this.parents, this.requiresParent, this.literalName, this.literalDescription);
        }
    }
}

