/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.method;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchMethodSerializer;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SequencedCollection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ConsumeItemResearchMethod(Ingredient toConsume, int count) implements ResearchMethod
{
    public static final ConsumeItemResearchMethod EMPTY = new ConsumeItemResearchMethod(Ingredient.EMPTY, 0);
    public static final ResourceLocation ID = Researchd.rl("consume_item");

    @Override
    public void checkProgress(Level level, ResourceKey<Research> research, ResearchProgress.Task task, ResearchMethod.MethodContext context) {
        block0: for (TeamMember member : context.team().getMembers()) {
            ArrayList<ItemStack> matchingItems = new ArrayList<ItemStack>(8);
            int found = 0;
            Player player = level.getPlayerByUUID(member.player());
            if (player == null) continue;
            int containerSize = player.getInventory().getContainerSize();
            for (int i = 0; i < containerSize; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (this.toConsume.test(stack)) {
                    matchingItems.add(stack);
                    found = Math.min(this.count, found + stack.getCount());
                }
                if (found < this.count) continue;
                int shrunkCount = 0;
                SequencedCollection itemsByLowestCount = matchingItems.stream().sorted(Comparator.comparingInt(ItemStack::getCount)).toList().reversed();
                for (ItemStack itemStack : itemsByLowestCount) {
                    int shrinkBy = Math.min(itemStack.getCount(), this.count() - shrunkCount);
                    itemStack.shrink(shrinkBy);
                    if ((shrunkCount += shrinkBy) < this.count()) continue;
                    task.addProgress(this.getMaxProgress());
                    continue block0;
                }
                continue block0;
            }
        }
    }

    @Override
    public float getMaxProgress() {
        return 1.0f;
    }

    @Override
    public ResearchProgress createProgress() {
        return ResearchProgress.single(this);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements ResearchMethodSerializer<ConsumeItemResearchMethod> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ConsumeItemResearchMethod> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("item").forGetter(ConsumeItemResearchMethod::toConsume), (App)Codec.INT.fieldOf("count").forGetter(ConsumeItemResearchMethod::count)).apply((Applicative)instance, ConsumeItemResearchMethod::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConsumeItemResearchMethod> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ConsumeItemResearchMethod::toConsume, (StreamCodec)ByteBufCodecs.INT, ConsumeItemResearchMethod::count, ConsumeItemResearchMethod::new);

        private Serializer() {
        }

        @Override
        @NotNull
        public MapCodec<ConsumeItemResearchMethod> codec() {
            return CODEC;
        }

        @Override
        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ConsumeItemResearchMethod> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

