/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.cache.AllPlayersCache;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.utils.ResearchdCodecUtils;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperClient;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ResearchTeamMap(Map<UUID, SimpleResearchTeam> researchTeams) {
    public static final ResearchTeamMap EMPTY = new ResearchTeamMap();
    public static final Codec<ResearchTeamMap> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING, SimpleResearchTeam.CODEC).fieldOf("research_teams").forGetter(t -> ResearchdCodecUtils.encodeMap(t.researchTeams))).apply((Applicative)builder, ResearchTeamMap::teamMapFromString));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResearchTeamMap> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, SimpleResearchTeam.STREAM_CODEC), t -> ResearchdCodecUtils.encodeMap(t.researchTeams), ResearchTeamMap::teamMapFromString);

    public ResearchTeamMap() {
        this(new HashMap<UUID, SimpleResearchTeam>());
    }

    @Nullable
    public SimpleResearchTeam getTeamByMember(UUID memberUuid) {
        return this.researchTeams.get(memberUuid);
    }

    @NotNull
    public ResearchTeam getTeamByMemberOrThrow(UUID memberUuid) {
        SimpleResearchTeam team = this.getTeamByMember(memberUuid);
        if (team != null) {
            return team;
        }
        throw new IllegalStateException("Player %s not in a team".formatted(AllPlayersCache.getName((UUID)memberUuid).equals("!Unknown Player!") ? memberUuid : AllPlayersCache.getName((UUID)memberUuid)));
    }

    public SimpleResearchTeam getTeamByPlayer(Player player) {
        return this.researchTeams.get(player.getUUID());
    }

    public SimpleResearchTeam getTeamByUUID(UUID teamUuid) {
        return this.researchTeams.get(teamUuid);
    }

    public static void onSync(Player player) {
        if (player.level().isClientSide) {
            ResearchHelperClient.refreshResearches(player);
            ClientResearchTeamHelper.resolveInstances(ClientResearchTeamHelper.getTeam());
        }
    }

    public void setDefaultTeam(UUID uuid, Level level) {
        this.researchTeams.put(uuid, SimpleResearchTeam.createDefaultTeam(uuid, level));
    }

    public void setDefaultTeam(ServerPlayer player) {
        this.setDefaultTeam(player.getUUID(), player.level());
    }

    public boolean initPlayer(ServerPlayer player) {
        try {
            if (this.getTeamByPlayer((Player)player) != null) {
                return false;
            }
            this.researchTeams.put(player.getUUID(), SimpleResearchTeam.createDefaultTeam(player));
            return true;
        }
        catch (Exception e) {
            Researchd.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static ResearchTeamMap teamMapFromString(Map<String, SimpleResearchTeam> stringedMap) {
        return new ResearchTeamMap(ResearchdCodecUtils.decodeMap(stringedMap, UUID::fromString));
    }
}

