/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.networking.research;

import com.portingdeadmods.portingdeadlibs.utils.Utils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.team.ResearchQueue;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.compat.KubeJSCompat;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ResearchFinishedPayload(ResourceKey<Research> key, int timeStamp) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResearchFinishedPayload> TYPE = new CustomPacketPayload.Type(Researchd.rl("research_finished"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, ResearchFinishedPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(ResearchdRegistries.RESEARCH_KEY), ResearchFinishedPayload::key, (StreamCodec)ByteBufCodecs.INT, ResearchFinishedPayload::timeStamp, ResearchFinishedPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void researchFinishedAction(IPayloadContext context) {
        context.enqueueWork(() -> {
            ResourceKey<Research> first;
            Player player = context.player();
            ResearchTeamMap data = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(player.level());
            SimpleResearchTeam team = data.getTeamByMember(player.getUUID());
            if (team == null) {
                context.disconnect((Component)ResearchdTranslations.component(ResearchdTranslations.Errors.NO_RESEARCH_TEAM, new Object[0]));
                return;
            }
            ResearchQueue queue = team.getQueue();
            if (queue.isEmpty()) {
                context.disconnect((Component)ResearchdTranslations.component(ResearchdTranslations.Errors.RESEARCH_QUEUE_DESYNC, new Object[0]));
            }
            if ((first = queue.getFirst()) != this.key()) {
                context.disconnect((Component)ResearchdTranslations.component(ResearchdTranslations.Errors.RESEARCH_QUEUE_DESYNC, new Object[0]));
            }
            team.completeResearch(first, this.timeStamp, player.level());
            queue.remove(0, false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                KubeJSCompat.fireResearchCompletedEvent(serverPlayer, this.key());
            }
            player.sendSystemMessage((Component)ResearchdTranslations.Research.QUEUE_FINISHED.component("researchd", new Object[]{String.valueOf(ChatFormatting.GREEN) + Utils.registryTranslation(first).getString() + String.valueOf(ChatFormatting.RESET), String.valueOf(ChatFormatting.GREEN) + ResearchHelperCommon.getResearchCompletionTime(team.getCreationTime(), this.timeStamp()) + String.valueOf(ChatFormatting.RESET)}));
            ClientResearchTeamHelper.refreshResearchScreenData();
            ResearchdSavedData.TEAM_RESEARCH.get().setData(player.level(), (Object)data);
        }).exceptionally(err -> {
            Researchd.LOGGER.error("Failed to handle ResearchFinishPayload: ", err);
            return null;
        });
    }
}

