/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.networking.research;

import com.portingdeadmods.portingdeadlibs.utils.Utils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdCommonConfig;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ResearchQueueAddPayload(ResourceKey<Research> researchKey, UUID player, long time) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResearchQueueAddPayload> TYPE = new CustomPacketPayload.Type(Researchd.rl("research_queue_add"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, ResearchQueueAddPayload> STREAM_CODEC = StreamCodec.composite(Research.RESOURCE_KEY_STREAM_CODEC, ResearchQueueAddPayload::researchKey, (StreamCodec)UUIDUtil.STREAM_CODEC, ResearchQueueAddPayload::player, (StreamCodec)ByteBufCodecs.VAR_LONG, ResearchQueueAddPayload::time, ResearchQueueAddPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                Level level = serverPlayer.level();
                ResearchTeamMap data = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level);
                SimpleResearchTeam team = data.getTeamByPlayer((Player)serverPlayer);
                if (team.getQueue().size() >= ResearchdCommonConfig.researchQueueLength) {
                    return;
                }
                ResearchInstance instance = team.getResearches().get(this.researchKey);
                instance.setResearchedPlayer(this.player);
                instance.setResearchedTime(this.time);
                boolean added = team.getQueue().add(instance);
                if (!added) {
                    return;
                }
                Component researchName = Utils.registryTranslation(this.researchKey);
                for (TeamMember memberId : team.getMembers()) {
                    ServerPlayer member = level.getServer().getPlayerList().getPlayer(memberId.player());
                    if (member == null) continue;
                    member.sendSystemMessage((Component)ResearchdTranslations.Research.QUEUE_ADDED.component("researchd", new Object[]{String.valueOf(ChatFormatting.GREEN) + serverPlayer.getDisplayName().getString() + String.valueOf(ChatFormatting.RESET), String.valueOf(ChatFormatting.GREEN) + researchName.getString() + String.valueOf(ChatFormatting.RESET)}));
                }
                team.getTeamResearches().refreshResearchStatus();
                ResearchdSavedData.TEAM_RESEARCH.get().setData(level, (Object)data);
                ResearchdSavedData.TEAM_RESEARCH.get().sync(level);
            }
        }).exceptionally(err -> {
            Researchd.LOGGER.error("Failed to handle ResearchQueueAdd payload", err);
            return null;
        });
    }
}

