/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.networking.team;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ManageModeratorPayload(UUID moderator, boolean remove) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ManageModeratorPayload> TYPE = new CustomPacketPayload.Type(Researchd.rl("manage_moderator_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ManageModeratorPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ManageModeratorPayload::moderator, (StreamCodec)ByteBufCodecs.BOOL, ManageModeratorPayload::remove, ManageModeratorPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void manageModeratorAction(ManageModeratorPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                ResearchTeamHelper.handleManageModerator(sp, payload.moderator(), payload.remove());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Action Failed:  " + e.getMessage())));
            return null;
        });
    }
}

