/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.translations;

import com.portingdeadmods.portingdeadlibs.api.translations.TranslatableConstant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;

public final class ResearchdTranslations {
    public static final Map<String, String> TRANSLATIONS = new HashMap<String, String>();
    public static final String AQUA_AT = String.valueOf(ChatFormatting.AQUA) + "@: " + String.valueOf(ChatFormatting.RESET);
    public static final String STR_PARAM = String.valueOf(ChatFormatting.YELLOW) + "%s" + String.valueOf(ChatFormatting.RESET);

    public static MutableComponent component(TranslatableConstant constant, Object ... args) {
        return constant.component("researchd", args);
    }

    public static void init() {
        Team.init();
        Research.init();
        Errors.init();
        Gui.init();
        Game.init();
    }

    public static final class Team {
        public static final TranslatableConstant OWNER = Team.create("role.owner", "Owner");
        public static final TranslatableConstant MEMBER = Team.create("role.member", "Member");
        public static final TranslatableConstant NOT_MEMBER = Team.create("role.not_player", "Not Member");
        public static final TranslatableConstant MODERATOR = Team.create("role.moderator", "Moderator");
        public static final TranslatableConstant SCREEN_TITLE = Team.create("screen.title", "Research Team");
        public static final TranslatableConstant SETTINGS_SCREEN_TITLE = Team.create("screen.settings.title", "Team Settings");
        public static final TranslatableConstant BUTTON_INVITE = Team.create("buttons.invite", "Invite Player");
        public static final TranslatableConstant BUTTON_TEAM_SETTINGS = Team.create("buttons.team_settings", "Team Settings");
        public static final TranslatableConstant BUTTON_MANAGE_MEMBERS = Team.create("buttons.manage_members", "Manage Members");
        public static final TranslatableConstant BUTTON_TRANSFER_OWNERSHIP = Team.create("buttons.transfer_ownership", "Transfer Ownership");
        public static final TranslatableConstant BUTTON_LEAVE_TEAM = Team.create("buttons.leave_team", "Leave Team");
        public static final TranslatableConstant TITLE_MEMBERS = Team.create("titles.members", "Members");
        public static final TranslatableConstant TITLE_RECENTLY_RESEARCHED = Team.create("titles.recently_researched", "Recently Researched");
        public static final TranslatableConstant SENT_INVITE = Team.create("sent_invite", AQUA_AT + String.valueOf(ChatFormatting.GREEN) + "You invited " + String.valueOf(ChatFormatting.RESET) + STR_PARAM + String.valueOf(ChatFormatting.GREEN) + " to join " + String.valueOf(ChatFormatting.RESET) + STR_PARAM + String.valueOf(ChatFormatting.GREEN) + "!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant REMOVED_INVITE = Team.create("removed_invite", AQUA_AT + String.valueOf(ChatFormatting.GREEN) + "Invite to " + String.valueOf(ChatFormatting.RESET) + STR_PARAM + String.valueOf(ChatFormatting.GREEN) + " has been removed!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant RECEIVED_INVITE = Team.create("received_invite", AQUA_AT + String.valueOf(ChatFormatting.GREEN) + "You were invited to join: " + String.valueOf(ChatFormatting.RESET) + STR_PARAM);
        public static final TranslatableConstant YOU_JOINED_TEAM = Team.create("joined_team", AQUA_AT + String.valueOf(ChatFormatting.GREEN) + "You joined: " + String.valueOf(ChatFormatting.RESET) + STR_PARAM + String.valueOf(ChatFormatting.GREEN) + "!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant PLAYER_JOINED_TEAM = Team.create("player_joined_team", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.GREEN) + " joined your team!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant LEFT_TEAM = Team.create("left_team", ChatFormatting.GREEN.toString() + String.valueOf(ChatFormatting.BOLD) + "You successfully abandoned your team!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant ACCEPT = Team.create("accept", ChatFormatting.GREEN.toString() + String.valueOf(ChatFormatting.BOLD) + String.valueOf(ChatFormatting.UNDERLINE) + "ACCEPT" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant DECLINE = Team.create("decline", ChatFormatting.RED.toString() + String.valueOf(ChatFormatting.BOLD) + String.valueOf(ChatFormatting.UNDERLINE) + "DECLINE" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant PROMOTED = Team.create("promoted", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " has been promoted to Moderator!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant DEMOTED = Team.create("demoted", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " has been demoted to Member!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant REMOVED = Team.create("removed", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " has been removed from the team!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant TRANSFERRED_OWNERSHIP = Team.create("transferred_ownership", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " is the new team owner!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant IGNORE = Team.create("ignore", AQUA_AT + String.valueOf(ChatFormatting.AQUA) + "Ignoring invites from " + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " from now on!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant NEW_TEAM_NAME = Team.create("new_team_name", AQUA_AT + STR_PARAM + String.valueOf(ChatFormatting.AQUA) + " changed to " + String.valueOf(ChatFormatting.RESET) + STR_PARAM + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant ALREADY_IN_TEAM = Team.create("already_in_team", ChatFormatting.BOLD.toString() + String.valueOf(ChatFormatting.RED) + "You gotta abandon your team first..." + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant NO_NEXT_LEADER = Team.create("no_next_leader", ChatFormatting.BOLD.toString() + String.valueOf(ChatFormatting.RED) + "You gotta specify the next leader..." + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant NO_PERMS = Team.create("no_perms", ChatFormatting.BOLD.toString() + String.valueOf(ChatFormatting.RED) + "You don't have the permissions to do that..." + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant KICKED = Team.create("kicked", AQUA_AT + String.valueOf(ChatFormatting.AQUA) + "You got kicked from " + STR_PARAM + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.AQUA) + " :< " + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant BAD_INPUT = Team.create("bad_input", ChatFormatting.BOLD.toString() + String.valueOf(ChatFormatting.RED) + "Invalid input... how even..." + String.valueOf(ChatFormatting.RESET));

        private static TranslatableConstant create(String key, String defaultValue) {
            TranslatableConstant constant = new TranslatableConstant(key, "team");
            TRANSLATIONS.put(constant.key("researchd"), defaultValue);
            return constant;
        }

        private static void init() {
        }
    }

    public static final class Research {
        public static final TranslatableConstant SCREEN_TITLE = Research.create("screen.title", "Researches");
        public static final TranslatableConstant QUEUE_ADDED = Research.create("queue.added", "%s added %s to the research queue!");
        public static final TranslatableConstant QUEUE_FINISHED = Research.create("queue.finished", "%s finished researching (%s)!");
        public static final TranslatableConstant SCREEN_LABEL_RESEARCH_COST = Research.create("screen.label.researched_by", "Cost");
        public static final TranslatableConstant SCREEN_LABEL_RESEARCH_EFFECTS = Research.create("screen.label.effects", "Effects");
        public static final TranslatableConstant DIMENSION_UNLOCK_EFFECT_TOOLTIP = Research.create("effects.tooltip.dimension_unlock", "Unlocks Dimension: %s");
        public static final TranslatableConstant RECIPE_UNLOCK_EFFECT_TOOLTIP_NO_ARG = Research.create("effects.tooltip.recipe_unlock_no_arg", "Unlocks Recipe: ");
        public static final TranslatableConstant RECIPE_UNLOCK_EFFECT_TOOLTIP = Research.create("effects.tooltip.recipe_unlock", "Unlocks Recipe: %s");
        public static final TranslatableConstant START_RESEARCH_BUTTON = Research.create("screen.button.start_research", "Start");
        public static final TranslatableConstant ENQUEUE_RESEARCH_BUTTON = Research.create("screen.button.enqueue_research", "Enqueue");

        private static TranslatableConstant create(String key, String defaultValue) {
            TranslatableConstant constant = new TranslatableConstant(key, "research");
            TRANSLATIONS.put(constant.key("researchd"), defaultValue);
            return constant;
        }

        private static void init() {
        }
    }

    public static final class Errors {
        public static final TranslatableConstant RESEARCH_QUEUE_DESYNC = Errors.create("research_queue_desync", "A small desynchronization happened regarding the Research Queue, please relog.");
        public static final TranslatableConstant NO_RESEARCH_TEAM = Errors.create("no_research_team", "Research related packet handled to player lacking a team");

        private static TranslatableConstant create(String key, String defaultValue) {
            TranslatableConstant constant = new TranslatableConstant(key, "error");
            TRANSLATIONS.put(constant.key("researchd"), defaultValue);
            return constant;
        }

        private static void init() {
        }
    }

    public static final class Gui {
        public static final TranslatableConstant RESEARCHED_BY_ON = Gui.create("researched_by_on", "Researched by %s on %s");

        private static TranslatableConstant create(String key, String defaultValue) {
            TranslatableConstant constant = new TranslatableConstant(key, "gui");
            TRANSLATIONS.put(constant.key("researchd"), defaultValue);
            return constant;
        }

        private static void init() {
        }
    }

    public static final class Game {
        public static final TranslatableConstant JOIN_MESSAGE = Game.create("join_message", AQUA_AT + String.valueOf(ChatFormatting.WHITE) + "Welcome to " + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.GREEN) + "Researchd Alpha" + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.WHITE) + "! Please note that things may break completely between updates. Feel free to report any issues on the GitHub page!" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant GITHUB = Game.create("github", String.valueOf(ChatFormatting.GREEN) + "GitHub" + String.valueOf(ChatFormatting.RESET));
        public static final TranslatableConstant WIKI = Game.create("wiki", String.valueOf(ChatFormatting.GREEN) + "Wiki" + String.valueOf(ChatFormatting.RESET));

        private static TranslatableConstant create(String key, String defaultValue) {
            TranslatableConstant constant = new TranslatableConstant(key, "game");
            TRANSLATIONS.put(constant.key("researchd"), defaultValue);
            return constant;
        }

        private static void init() {
        }
    }
}

