/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.utils.researches;

import com.portingdeadmods.researchd.ResearchdClient;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchIcon;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectData;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.impl.team.SimpleResearchTeam;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class ResearchHelperClient {
    public static void refreshResearches(Player player) {
        ClientLevel level = Minecraft.getInstance().level;
        ResearchTeamMap researchData = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        SimpleResearchTeam team = researchData.getTeamByMember(player.getUUID());
        for (Map.Entry entry : NeoForgeRegistries.ATTACHMENT_TYPES.entrySet()) {
            Object data = player.getData((AttachmentType)entry.getValue());
            if (!(data instanceof ResearchEffectData)) continue;
            ResearchEffectData effectData = (ResearchEffectData)data;
            player.setData((AttachmentType)entry.getValue(), effectData.getDefault((Level)level));
        }
        for (ResearchInstance res : team.getResearches().values()) {
            if (res.getResearchStatus() != ResearchStatus.RESEARCHED) continue;
            ResearchEffect effect = res.lookup((Level)level).researchEffect();
            effect.onUnlock((Level)level, player, res.getKey());
        }
    }

    public static Map<ResourceKey<ResearchPack>, ResearchPack> getResearchPacks() {
        return ResearchHelperCommon.getResearchPacks((Level)Minecraft.getInstance().level);
    }

    public static void initIconRenderers(Level level) {
        CommonResearchCache.GLOBAL_RESEARCHES.forEach((k, v) -> {
            ResearchIcon icon = v.getResearch(level).researchIcon();
            ResearchScreen.CLIENT_ICONS.put(k.location(), ResearchdClient.RESEARCH_ICONS.get(icon.id()).apply(icon));
        });
    }

    public static Research getResearch(ResourceKey<Research> researchKey) {
        return ResearchHelperCommon.getResearch(researchKey, (Level)Minecraft.getInstance().level);
    }
}

