/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd;

import com.mojang.logging.LogUtils;
import com.portingdeadmods.portingdeadlibs.api.resources.DynamicPack;
import com.portingdeadmods.researchd.ResearchdConfig;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.networking.registries.UpdateResearchPacksPayload;
import com.portingdeadmods.researchd.networking.registries.UpdateResearchesPayload;
import com.portingdeadmods.researchd.networking.research.ResearchCacheReloadPayload;
import com.portingdeadmods.researchd.pdl.config.PDLConfigHelper;
import com.portingdeadmods.researchd.registries.ResearchdBlockEntityTypes;
import com.portingdeadmods.researchd.registries.ResearchdBlocks;
import com.portingdeadmods.researchd.registries.ResearchdDataComponents;
import com.portingdeadmods.researchd.registries.ResearchdItems;
import com.portingdeadmods.researchd.registries.ResearchdMenuTypes;
import com.portingdeadmods.researchd.registries.ResearchdTab;
import com.portingdeadmods.researchd.registries.ResearchdValueEffects;
import com.portingdeadmods.researchd.registries.serializers.ResearchEffectSerializers;
import com.portingdeadmods.researchd.registries.serializers.ResearchMethodSerializers;
import com.portingdeadmods.researchd.registries.serializers.ResearchPackSerializers;
import com.portingdeadmods.researchd.registries.serializers.ResearchSerializers;
import com.portingdeadmods.researchd.resources.ResearchdDynamicPackContents;
import com.portingdeadmods.researchd.resources.ResearchdExamplesSource;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import com.portingdeadmods.researchd.utils.researches.ResearchdManagers;
import java.util.HashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;

@Mod(value="researchd")
public final class Researchd {
    public static final String MODID = "researchd";
    public static final String MODNAME = "Researchd";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void debug(String category, Object ... message) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(category).append("] ");
        for (Object msg : message) {
            sb.append(msg.toString());
        }
        if (ResearchdConfig.Common.consoleDebug) {
            LOGGER.debug(sb.toString());
        }
    }

    public Researchd(IEventBus modEventBus, ModContainer modContainer) {
        ResearchdAttachments.ATTACHMENTS.register(modEventBus);
        ResearchSerializers.SERIALIZERS.register(modEventBus);
        ResearchEffectSerializers.SERIALIZERS.register(modEventBus);
        ResearchMethodSerializers.SERIALIZERS.register(modEventBus);
        ResearchdItems.ITEMS.register(modEventBus);
        ResearchdDataComponents.COMPONENTS.register(modEventBus);
        ResearchdTab.TABS.register(modEventBus);
        ResearchdSavedData.SAVED_DATA.register(modEventBus);
        ResearchdBlocks.BLOCKS.register(modEventBus);
        ResearchdBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        ResearchdMenuTypes.MENU_TYPES.register(modEventBus);
        ResearchdValueEffects.VALUE_EFFECTS.register(modEventBus);
        ResearchPackSerializers.SERIALIZERS.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(this::registerDatapackRegistries);
        modEventBus.addListener(this::addPackFinders);
        NeoForge.EVENT_BUS.addListener(this::onDatapacksSynced);
        PDLConfigHelper.registerConfig(ResearchdConfig.Client.class, ModConfig.Type.CLIENT).register(modContainer);
        PDLConfigHelper.registerConfig(ResearchdConfig.Common.class, ModConfig.Type.COMMON).register(modContainer);
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (ResearchdConfig.Common.loadExamplesDatapack) {
            DynamicPack pack = new DynamicPack(Researchd.rl("example_researches"), event.getPackType(), PackSource.FEATURE);
            switch (event.getPackType()) {
                case CLIENT_RESOURCES: {
                    ResearchdDynamicPackContents.writeAssets(pack);
                    break;
                }
                case SERVER_DATA: {
                    ResearchdDynamicPackContents.writeData(pack);
                }
            }
            event.addRepositorySource((RepositorySource)new ResearchdExamplesSource(pack.packId(), event.getPackType(), Pack.Position.BOTTOM, (PackResources)pack));
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ResearchdBlockEntityTypes.RESEARCH_LAB_PART.get(), (be, dir) -> be.getControllerItemHandler());
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(ResearchdRegistries.RESEARCH_SERIALIZER);
        event.register(ResearchdRegistries.RESEARCH_PACK_SERIALIZER);
        event.register(ResearchdRegistries.RESEARCH_EFFECT_SERIALIZER);
        event.register(ResearchdRegistries.RESEARCH_METHOD_SERIALIZER);
        event.register(ResearchdRegistries.VALUE_EFFECT);
    }

    private void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ResearchdRegistries.RESEARCH_KEY, Research.CODEC, Research.CODEC);
        event.dataPackRegistry(ResearchdRegistries.RESEARCH_PACK_KEY, ResearchPackImpl.CODEC, ResearchPackImpl.CODEC);
    }

    private void onDatapacksSynced(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        MinecraftServer server = event.getPlayerList().getServer();
        CommonResearchCache.initialize((Level)server.overworld());
        ServerLevel overworld = server.overworld();
        ResearchTeamMap teamMap = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)overworld);
        ResearchTeamHelper.resolveGlobalResearches(teamMap);
        ResearchTeamHelper.cleanupTeamResearches(teamMap, (Level)overworld);
        ResearchTeamHelper.initializeTeamResearches(teamMap, (Level)overworld);
        ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)overworld, (Object)teamMap);
        ResearchdSavedData.TEAM_RESEARCH.get().sync((Level)overworld);
        if (player != null) {
            Researchd.updateReloadableRegistries(player);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)ResearchCacheReloadPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            event.getRelevantPlayers().forEach(Researchd::updateReloadableRegistries);
            event.getRelevantPlayers().forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)ResearchCacheReloadPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    private static void updateReloadableRegistries(ServerPlayer p) {
        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new UpdateResearchesPayload(new HashMap<ResourceLocation, Research>(ResearchdManagers.getResearchesManager(p.level()).getByName())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new UpdateResearchPacksPayload(new HashMap<ResourceLocation, ResearchPack>(ResearchdManagers.getResearchPacksManager(p.level()).getByName())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

