/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.client;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.Level;

public record TechList(UniqueArray<ResearchInstance> entries) {
    public TechList(Set<ResearchInstance> entries) {
        this((UniqueArray<ResearchInstance>)new UniqueArray(entries));
        this.sortTechList();
    }

    public static TechList getClientTechList() {
        return new TechList(new HashSet<ResearchInstance>(ClientResearchTeamHelper.getTeam().getResearches().values()));
    }

    public void sortTechList() {
        List sorted = this.entries.stream().sorted((a, b) -> {
            if (a.getResearchStatus() == b.getResearchStatus()) {
                return a.getKey().location().toString().compareTo(b.getKey().location().toString());
            }
            return a.getResearchStatus().getSortingValue() - b.getResearchStatus().getSortingValue();
        }).toList();
        this.entries.clear();
        this.entries.addAll(sorted);
    }

    public TechList getListForSearch(String searchVal, Level level) {
        UniqueArray entries = new UniqueArray();
        String searchLower = searchVal.strip().toLowerCase();
        for (ResearchInstance entry : this.entries()) {
            String resourceLocation = entry.getKey().location().toString().toLowerCase();
            String displayName = entry.getDisplayName(level).getString().toLowerCase();
            String description = entry.getDescription(level).getString().toLowerCase();
            if (!resourceLocation.contains(searchLower) && !displayName.contains(searchLower) && !description.contains(searchLower)) continue;
            entries.add(entry);
        }
        return new TechList((Set<ResearchInstance>)entries);
    }
}

