/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.client.widgets;

import com.portingdeadmods.researchd.Researchd;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public abstract class ContainerWidget<E>
extends AbstractWidget {
    public static final ResourceLocation SCROLLER_SMALL_SPRITE = Researchd.rl("scroller_small");
    private final int itemWidth;
    private final int itemHeight;
    private final Collection<E> items;
    private final boolean renderScroller;
    protected int scrollOffset;

    public ContainerWidget(int width, int height, int itemWidth, int itemHeight, Collection<E> items, boolean renderScroller) {
        this(0, 0, width, height, itemWidth, itemHeight, items, renderScroller);
    }

    public ContainerWidget(int x, int y, int width, int height, int itemWidth, int itemHeight, Collection<E> items, boolean renderScroller) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.items = items;
        this.renderScroller = renderScroller;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.enableScissor(this.getLeft(), this.getTop(), this.getX() + this.getItemWidth(), this.getY() + this.getHeight());
        this.renderContainer(guiGraphics, mouseX, mouseY);
        guiGraphics.disableScissor();
        if (this.renderScroller) {
            float percentage = (float)this.scrollOffset / (float)(this.getContentHeight() - this.getHeight());
            guiGraphics.blitSprite(SCROLLER_SMALL_SPRITE, this.getLeft() + this.getItemWidth() + 3, (int)((float)this.getTop() + percentage * (float)(this.getHeight() - 7)), 4, 7);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.getContentHeight() > this.getHeight()) {
            double rawScrollOffset = Math.max((double)this.scrollOffset - scrollY * 7.0, 0.0);
            this.scrollOffset = rawScrollOffset > (double)(this.getContentHeight() - this.getHeight() + 1) ? this.getContentHeight() - this.getHeight() : (int)rawScrollOffset;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isScrollbarHovered(int mouseX, int mouseY) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered() && !this.isScrollbarHovered((int)mouseX, (int)mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isHovered() && this.isScrollbarHovered((int)mouseX, (int)mouseY) && this.renderScroller) {
            int scrollableHeight = this.getContentHeight() - this.getHeight();
            int minY = this.getY() + 7;
            int maxY = this.getY() + this.getHeight() - 7;
            double scrolledPercentage = (Math.clamp(mouseY, (double)minY, (double)maxY) - (double)minY) / (double)(maxY - minY);
            this.scrollOffset = (int)((double)scrollableHeight * scrolledPercentage);
            return true;
        }
        return false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.isScrollbarHovered((int)mouseX, (int)mouseY)) {
            this.mouseClicked(mouseX, mouseY, 0);
        }
    }

    public Collection<E> getItems() {
        return this.items;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public int getContentHeight() {
        return this.getItems().size() * this.getItemHeight();
    }

    private int getTop() {
        return this.getY() + 1;
    }

    private int getLeft() {
        return this.getX() + 1;
    }

    public void renderContainer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int index = 0;
        for (E item : this.items) {
            this.renderItem(guiGraphics, item, index, this.getLeft(), this.getTop() + index * this.getItemHeight() - this.scrollOffset, mouseX, mouseY);
            ++index;
        }
    }

    public boolean isItemHovered(int index, int mouseX, int mouseY) {
        return mouseX > this.getLeft() && mouseX < this.getLeft() + this.getItemWidth() && mouseY > this.getTop() + this.itemHeight * index - this.scrollOffset && mouseY < this.getTop() + this.itemHeight * (index + 1) - this.scrollOffset;
    }

    protected void sortEntriesBy(Comparator<? super E> comparator) {
        Collection<E> collection = this.items;
        if (collection instanceof List) {
            List list = (List)collection;
            list.sort(comparator);
        }
    }

    public abstract void clickedItem(E var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void renderItem(GuiGraphics var1, E var2, int var3, int var4, int var5, int var6, int var7);

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

