/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class GlobalResearch {
    public static final Codec<GlobalResearch> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Research.RESOURCE_KEY_CODEC.fieldOf("research").forGetter(GlobalResearch::getResearchKey)).apply((Applicative)instance, GlobalResearch::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlobalResearch> STREAM_CODEC = StreamCodec.composite(Research.RESOURCE_KEY_STREAM_CODEC, GlobalResearch::getResearchKey, GlobalResearch::new);
    private final ResourceKey<Research> research;
    private Set<GlobalResearch> children;
    private Set<GlobalResearch> parents;

    public GlobalResearch(ResourceKey<Research> research) {
        this.research = research;
        this.children = new HashSet<GlobalResearch>();
        this.parents = new HashSet<GlobalResearch>();
    }

    public boolean is(ResourceKey<Research> research) {
        return this.research.compareTo(research) == 0;
    }

    public ResourceKey<Research> getResearchKey() {
        return this.research;
    }

    public Research getResearch(Level level) {
        return ResearchHelperCommon.getResearch(this.getResearchKey(), level);
    }

    public Set<GlobalResearch> getChildren() {
        return this.children;
    }

    public Set<GlobalResearch> getParents() {
        return this.parents;
    }

    public void lock() {
        this.children = new ImmutableSet.Builder().addAll(this.children).build();
        this.parents = new ImmutableSet.Builder().addAll(this.parents).build();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GlobalResearch)) {
            return false;
        }
        GlobalResearch that = (GlobalResearch)o;
        return Objects.equals(this.research, that.research);
    }

    public int hashCode() {
        return Objects.hashCode(this.research);
    }

    public String toString() {
        return "GlobalResearch{research=" + String.valueOf(this.research) + "}";
    }
}

