/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research;

import com.mojang.serialization.Codec;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.ResearchIcon;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchSerializer;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public interface Research {
    public static final Codec<Research> CODEC = ResearchdRegistries.RESEARCH_SERIALIZER.byNameCodec().dispatch(Research::getSerializer, ResearchSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Research> STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC).cast();
    public static final Codec<ResourceKey<Research>> RESOURCE_KEY_CODEC = ResourceKey.codec(ResearchdRegistries.RESEARCH_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<Research>> RESOURCE_KEY_STREAM_CODEC = ResourceKey.streamCodec(ResearchdRegistries.RESEARCH_KEY);

    public ResearchIcon researchIcon();

    public ResearchMethod researchMethod();

    public ResearchEffect researchEffect();

    public List<ResourceKey<Research>> parents();

    public boolean requiresParent();

    public ResearchSerializer<?> getSerializer();

    public static Component getLangName(ResourceKey<Research> key) {
        String registryPath = ResearchdRegistries.RESEARCH_KEY.location().getPath();
        String keyNamespace = key.location().getNamespace();
        String keyPath = key.location().getPath();
        return Component.translatable((String)String.format("%s.%s.%s_name", registryPath, keyNamespace, keyPath));
    }

    public static Component getLangDesc(ResourceKey<Research> key) {
        String registryPath = ResearchdRegistries.RESEARCH_KEY.location().getPath();
        String keyNamespace = key.location().getNamespace();
        String keyPath = key.location().getPath();
        return Component.translatable((String)String.format("%s.%s.%s_desc", registryPath, keyNamespace, keyPath));
    }
}

