/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research.packs;

import com.mojang.serialization.Codec;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.serializers.ResearchPackSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface ResearchPack {
    public static final Codec<ResourceKey<ResearchPack>> RESOURCE_KEY_CODEC = ResourceKey.codec(ResearchdRegistries.RESEARCH_PACK_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<ResearchPack>> RESOURCE_KEY_STREAM_CODEC = ResourceKey.streamCodec(ResearchdRegistries.RESEARCH_PACK_KEY);
    public static final Codec<ResearchPack> CODEC = ResearchdRegistries.RESEARCH_PACK_SERIALIZER.byNameCodec().dispatch(ResearchPack::getSerializer, ResearchPackSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResearchPack> STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC).cast();

    public int color();

    public int sortingValue();

    public Optional<ResourceLocation> customTexture();

    public ResearchPackSerializer<?> getSerializer();

    public static Component getLangName(ResourceKey<ResearchPack> key) {
        String registryPath = ResearchdRegistries.RESEARCH_PACK_KEY.location().getPath();
        String keyNamespace = key.location().getNamespace();
        String keyPath = key.location().getPath();
        return Component.translatable((String)String.format("%s.%s.%s_name", registryPath, keyNamespace, keyPath));
    }

    public static Component getLangDesc(ResourceKey<ResearchPack> key) {
        String registryPath = ResearchdRegistries.RESEARCH_PACK_KEY.location().getPath();
        String keyNamespace = key.location().getNamespace();
        String keyPath = key.location().getPath();
        return Component.translatable((String)String.format("%s.%s.%s_desc", registryPath, keyNamespace, keyPath));
    }
}

