/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl.effects;

import com.portingdeadmods.researchd.ResearchdClient;
import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectList;
import com.portingdeadmods.researchd.utils.WidgetConstructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.common.util.Size2i;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractResearchEffectListWidget<T extends ResearchEffectList>
extends AbstractResearchInfoWidget<T> {
    private final List<AbstractResearchInfoWidget<? extends ResearchEffect>> effects = new ArrayList<AbstractResearchInfoWidget<? extends ResearchEffect>>();

    public AbstractResearchEffectListWidget(int x, int y, T effect) {
        super(x, y, effect);
        List<ResearchEffect> effects = effect.effects();
        for (int i = 0; i < effects.size(); ++i) {
            ResearchEffect researchEffect = effects.get(i);
            int xSize = i > 0 ? (int)((float)this.getSizeFor((int)i, (boolean)false).width + (float)i * this.getPadding()) : 0;
            WidgetConstructor<? extends ResearchEffect> widgetConstructor = ResearchdClient.RESEARCH_EFFECT_WIDGETS.get(researchEffect.id());
            if (widgetConstructor == null) continue;
            this.effects.add(widgetConstructor.createEffect(x + xSize + 1, y + 1, researchEffect));
        }
        Size2i size = this.getSize(true);
        this.setWidth(size.width);
        this.setHeight(size.height);
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        for (AbstractResearchInfoWidget<? extends ResearchEffect> widget : this.effects) {
            consumer.accept(widget);
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getX();
        int y = this.getY();
        Size2i firstSize = this.getSizeFor(1, false);
        guiGraphics.fill(x, y, x + this.width, y + firstSize.height, FastColor.ARGB32.color((int)92, (int)92, (int)92));
        List<ResearchEffect> effects = ((ResearchEffectList)this.value).effects();
        for (int i = 0; i < effects.size(); ++i) {
            if (i < this.effects.size()) {
                this.effects.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
            }
            float padding = this.getPadding();
            if (i <= 0 || i - 1 == effects.size()) continue;
            int xSize1 = (int)((float)this.getSizeFor((int)i, (boolean)false).width + (float)(i - 1) * padding);
            Objects.requireNonNull(Minecraft.getInstance().font);
            int ySize = (this.height - 9) / 2;
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getSeparatorText(), (int)((float)(x + xSize1) + this.getPadding() / 2.0f), y + ySize + 1, -1);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (AbstractResearchInfoWidget<? extends ResearchEffect> researchEffect : this.effects) {
            researchEffect.renderTooltip(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @NotNull
    public abstract String getSeparatorText();

    @Override
    public Size2i getSize() {
        return this.getSizeFor(((ResearchEffectList)this.value).effects().size(), false);
    }

    public void setY(int y) {
        super.setY(y);
        for (AbstractResearchInfoWidget<? extends ResearchEffect> effect : this.effects) {
            effect.setY(y + 1);
        }
    }

    public void setX(int x) {
        super.setX(x);
        for (AbstractResearchInfoWidget<? extends ResearchEffect> effect : this.effects) {
            effect.setX(x + 1 + this.getSizeFor((int)this.effects.indexOf(effect), (boolean)false).width + this.effects.indexOf(effect) * (int)this.getPadding());
        }
    }

    public float getPadding() {
        Font font = Minecraft.getInstance().font;
        return font.width(this.getSeparatorText()) + 4;
    }

    public Size2i getSize(boolean includePadding) {
        return this.getSizeFor(((ResearchEffectList)this.value).effects().size(), includePadding);
    }

    @NotNull
    public Size2i getSizeFor(int amount, boolean includePadding) {
        List<AbstractResearchInfoWidget<? extends ResearchEffect>> methods = this.effects;
        if (methods == null) {
            methods = new ArrayList<AbstractResearchInfoWidget<? extends ResearchEffect>>();
            for (ResearchEffect researchEffect : ((ResearchEffectList)this.value).effects()) {
                WidgetConstructor<? extends ResearchEffect> widgetConstructor = ResearchdClient.RESEARCH_EFFECT_WIDGETS.get(researchEffect.id());
                if (widgetConstructor == null) continue;
                methods.add(widgetConstructor.createEffect(0, 0, researchEffect));
            }
        }
        if (!methods.isEmpty()) {
            AbstractResearchInfoWidget<? extends ResearchEffect> first = methods.getFirst();
            Size2i firstMethodSize = first.getSize();
            Size2i size = new Size2i(0, firstMethodSize.height + 2);
            for (int i = 0; i < amount; ++i) {
                AbstractResearchInfoWidget<? extends ResearchEffect> researchMethod = methods.get(i);
                size = new Size2i((int)((float)(size.width + researchMethod.getWidth()) + (includePadding && i > 0 ? this.getPadding() : 0.0f)) + 2, size.height);
            }
            return size;
        }
        return new Size2i(0, 0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractResearchInfoWidget<? extends ResearchEffect> effect : this.effects) {
            if (!effect.isHovered()) continue;
            return effect.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }
}

