/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl.effects;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.compat.JEICompat;
import com.portingdeadmods.researchd.compat.ResearchdCompatHandler;
import com.portingdeadmods.researchd.impl.research.effect.RecipeUnlockEffect;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Size2i;

public class RecipeUnlockEffectWidget
extends AbstractResearchInfoWidget<RecipeUnlockEffect> {
    public static final ResourceLocation RECIPE_ICON_SPRITE = Researchd.rl("recipe_icon");
    public final Integer textWidth;
    public final List<RecipeHolder<?>> recipes;
    public final ItemStack icon;

    public RecipeUnlockEffectWidget(int x, int y, RecipeUnlockEffect method) {
        super(x, y, method);
        this.textWidth = this.font.width((FormattedText)ResearchdTranslations.component(ResearchdTranslations.Research.RECIPE_UNLOCK_EFFECT_TOOLTIP_NO_ARG, new Object[0]));
        this.recipes = method.getRecipes((Level)Minecraft.getInstance().level).stream().toList();
        List<ItemStack> resultItems = this.recipes.stream().map(RecipeHolder::value).map(r -> r.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())).toList();
        this.icon = method.icon().orElseGet(() -> this.getMostCommonResultItem(resultItems));
    }

    private ItemStack getMostCommonResultItem(List<ItemStack> resultItems) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (ItemStack item : resultItems) {
            map.merge(item, 1, Integer::sum);
        }
        return map.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(ItemStack.EMPTY);
    }

    @Override
    public Size2i getSize() {
        return new Size2i(16, 16);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.icon != null) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, FastColor.ARGB32.color((int)69, (int)69, (int)69));
            guiGraphics.renderItem(this.icon, this.getX(), this.getY());
            guiGraphics.blitSprite(RECIPE_ICON_SPRITE, this.getX() + 7, this.getY() + 6, 200, 16, 16);
        } else {
            guiGraphics.drawString(this.font, "MISSING RECIPE", this.getX() + 2, this.getY() + 4, 0xFF5555, true);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHovered()) {
            MutableComponent component = ResearchdTranslations.component(ResearchdTranslations.Research.RECIPE_UNLOCK_EFFECT_TOOLTIP, ((RecipeUnlockEffect)this.value).recipes().toString());
            guiGraphics.renderTooltip(this.font, (Component)component, mouseX, mouseY);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.isHovered() && ResearchdCompatHandler.isJeiLoaded()) {
            Set<RecipeHolder<?>> recipes1 = ((RecipeUnlockEffect)this.value).getRecipes((Level)Minecraft.getInstance().level);
            JEICompat.openRecipes(recipes1);
        }
    }
}

