/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl.effects;

import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.compat.JEICompat;
import com.portingdeadmods.researchd.compat.ResearchdCompatHandler;
import com.portingdeadmods.researchd.impl.research.effect.UnlockItemEffect;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Size2i;

public class UnlockItemEffectWidget
extends AbstractResearchInfoWidget<UnlockItemEffect> {
    private final ItemStack icon;

    public UnlockItemEffectWidget(int x, int y, UnlockItemEffect effect) {
        super(x, y, effect);
        this.icon = effect.getDisplayStack();
    }

    @Override
    public Size2i getSize() {
        return new Size2i(16, 16);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, FastColor.ARGB32.color((int)69, (int)69, (int)69));
        if (!this.icon.isEmpty()) {
            guiGraphics.renderItem(this.icon, this.getX(), this.getY());
        } else {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"?"), this.getX() + 5, this.getY() + 4, 0xFFFFFF, false);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered()) {
            MutableComponent defaultName = Component.translatable((String)((UnlockItemEffect)this.value).getItem().getDescriptionId());
            Component displayName = (Component)((UnlockItemEffect)this.value).name().map(Component::literal).orElse(defaultName);
            MutableComponent message = ResearchdTranslations.component(ResearchdTranslations.Research.ITEM_UNLOCK_EFFECT_TOOLTIP, displayName);
            guiGraphics.renderTooltip(this.font, (Component)message, mouseX, mouseY);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        Set<RecipeHolder<?>> recipes;
        if (this.isHovered() && ResearchdCompatHandler.isJeiLoaded() && !(recipes = ((UnlockItemEffect)this.value).getRecipes((Level)Minecraft.getInstance().level)).isEmpty()) {
            JEICompat.openRecipes(recipes);
        }
    }
}

