/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl.methods;

import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.impl.research.method.ConsumePackResearchMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Size2i;

public class ConsumePackResearchMethodWidget
extends AbstractResearchInfoWidget<ConsumePackResearchMethod> {
    public static final int GAP_BETWEEN_PACKS = 4;
    public final int count;
    public final int duration;
    public final int types;
    public final int textWidth;
    private final List<ItemStack> stacks;

    public ConsumePackResearchMethodWidget(int x, int y, ConsumePackResearchMethod method) {
        super(x, y, method);
        this.count = method.count();
        this.duration = method.duration();
        this.types = method.packs().size();
        this.textWidth = Minecraft.getInstance().font.width(" x %dt".formatted(this.duration));
        this.stacks = new ArrayList<ItemStack>();
        List<ItemStack> asStacks = ((ConsumePackResearchMethod)this.value).asStacks();
        for (ItemStack stack : asStacks) {
            this.stacks.add(stack.copyWithCount(((ConsumePackResearchMethod)this.value).count()));
        }
        this.setWidth(16 + 4 * method.packs().size() + this.textWidth);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.fill(x, y, x + this.width, y + this.height, FastColor.ARGB32.color((int)69, (int)69, (int)69));
        for (int idx = 0; idx < this.stacks.size(); ++idx) {
            ItemStack stack = this.stacks.get(idx);
            int xPos = x + idx * 4;
            guiGraphics.renderItem(stack, xPos, y);
            if (idx != this.stacks.size() - 1) continue;
            guiGraphics.renderItemDecorations(this.font, stack, xPos, y);
        }
        Font font = Minecraft.getInstance().font;
        String string = " x %dt".formatted(this.duration);
        int n = x + 14 + 4 * this.stacks.size();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(font, string, n, y + (int)((16.0f - 9.0f) / 2.0f) + 2, 0xFFFFFF, true);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        if (this.isHovered()) {
            guiGraphics.renderTooltip(font, (Component)Component.literal((String)"Consume ").append((Component)Component.literal((String)"%d".formatted(this.count)).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)(this.count == 1 ? " pack for " : " packs for "))).append((Component)Component.literal((String)"%d".formatted(this.duration)).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)(this.duration == 1 ? " tick" : " ticks"))).append((Component)Component.literal((String)(this.count == 1 ? "." : " each."))), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    @Override
    public Size2i getSize() {
        return new Size2i(16, 16);
    }
}

