/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research;

import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.ClientResearchIcon;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.api.client.TechList;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.client.cache.ResearchGraphCache;
import com.portingdeadmods.researchd.client.screens.research.widgets.ResearchGraphWidget;
import com.portingdeadmods.researchd.client.screens.research.widgets.ResearchQueueWidget;
import com.portingdeadmods.researchd.client.screens.research.widgets.SelectedResearchWidget;
import com.portingdeadmods.researchd.client.screens.research.widgets.TechListWidget;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ResearchScreen
extends Screen {
    public static final ResourceLocation TOP_RIGHT_EDGE = Researchd.rl("textures/gui/research_screen/edges/top_right.png");
    public static final ResourceLocation BOTTOM_RIGHT_EDGE = Researchd.rl("textures/gui/research_screen/edges/bottom_right.png");
    public static final ResourceLocation TOP_BAR = Researchd.rl("textures/gui/research_screen/bars/top.png");
    public static final ResourceLocation BOTTOM_BAR = Researchd.rl("textures/gui/research_screen/bars/bottom.png");
    public static final ResourceLocation RIGHT_BAR = Researchd.rl("textures/gui/research_screen/bars/right.png");
    public static final Map<ResourceLocation, ClientResearchIcon<?>> CLIENT_ICONS = new HashMap();
    private TechListWidget techListWidget;
    private ResearchQueueWidget researchQueueWidget;
    private ResearchGraphWidget researchGraphWidget;
    private SelectedResearchWidget selectedResearchWidget;

    public ResearchScreen() {
        super((Component)ResearchdTranslations.component(ResearchdTranslations.Research.SCREEN_TITLE, new Object[0]));
    }

    protected void init() {
        super.init();
        this.techListWidget = new TechListWidget(this, 0, 109, 7);
        this.techListWidget.setTechList(TechList.getClientTechList());
        this.researchQueueWidget = new ResearchQueueWidget(this, 0, 0);
        this.selectedResearchWidget = new SelectedResearchWidget(this, 0, 40, 174, 72);
        if (!this.techListWidget.getTechList().entries().isEmpty()) {
            this.selectedResearchWidget.setSelectedResearch((ResearchInstance)this.techListWidget.getTechList().entries().getFirst());
        }
        int x = 174;
        this.researchGraphWidget = new ResearchGraphWidget(this, x, 8, 300, 237);
        if (CommonResearchCache.rootResearch != null) {
            this.researchGraphWidget.setGraph(ResearchGraphCache.computeIfAbsent(CommonResearchCache.rootResearch.getResearchKey()));
        }
        this.techListWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.researchQueueWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.selectedResearchWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.researchGraphWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)BOTTOM_RIGHT_EDGE, (int)(this.width - 8), (int)(this.height - 8), (int)8, (int)8);
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)TOP_RIGHT_EDGE, (int)(this.width - 8), (int)0, (int)8, (int)8);
        int w = 174;
        guiGraphics.blit(TOP_BAR, w, 0, 0.0f, 0.0f, guiGraphics.guiWidth() - w - 8, 8, 256, 8);
        guiGraphics.blit(BOTTOM_BAR, w, guiGraphics.guiHeight() - 8, 0.0f, 0.0f, guiGraphics.guiWidth() - w - 8, 8, 256, 8);
        guiGraphics.blit(RIGHT_BAR, this.width - 8, 8, 0.0f, 0.0f, 8, guiGraphics.guiHeight() - 8 - 8, 8, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int w = 174;
        this.researchGraphWidget.setSize(guiGraphics.guiWidth() - 8 - w, guiGraphics.guiHeight() - 16);
        this.researchGraphWidget.renderNodeTooltips(guiGraphics, mouseX, mouseY, partialTick);
        this.selectedResearchWidget.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    public ResearchGraphWidget getResearchGraphWidget() {
        return this.researchGraphWidget;
    }

    public SelectedResearchWidget getSelectedResearchWidget() {
        return this.selectedResearchWidget;
    }

    public ResearchQueueWidget getResearchQueueWidget() {
        return this.researchQueueWidget;
    }

    public TechListWidget getTechListWidget() {
        return this.techListWidget;
    }

    public ResearchGraph getResearchGraph() {
        return this.researchGraphWidget.getCurrentGraph();
    }

    public TechList getTechList() {
        return this.techListWidget.getTechList();
    }

    public void onClose() {
        super.onClose();
        if (this.researchGraphWidget != null) {
            this.researchGraphWidget.onClose();
        }
    }
}

