/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.research.graph.ResearchNode;
import com.portingdeadmods.researchd.client.screens.research.widgets.ResearchGraphWidget;
import com.portingdeadmods.researchd.utils.Spaghetti;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;

public class GraphLayoutManager {
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 20;
    private static final int NODE_WIDTH = 20;
    private static final int NODE_HEIGHT = 24;
    public static Int2ObjectMap<List<ResearchNode>> layerMap = new Int2ObjectOpenHashMap();
    public static Map<ResearchNode, Integer> nodeLayerMap = new HashMap<ResearchNode, Integer>();

    public static void applyLayout(ResearchGraph graph, int offsetX, int offsetY) {
        if (graph == null || graph.nodes().isEmpty()) {
            return;
        }
        nodeLayerMap.clear();
        layerMap.clear();
        GraphLayoutManager._addRightToLayer(0, graph.rootNode());
        GraphLayoutManager.calculateLayers(graph, graph.rootNode());
        GraphLayoutManager.positionNodesInLayers(offsetX, offsetY);
        GraphLayoutManager.centerNodesBasedOnLayers();
        GraphLayoutManager.sortNodesBasedOnParents();
        GraphLayoutManager.handleNodeShiftingFromAbove();
        GraphLayoutManager.resolveOverlaps(4);
        GraphLayoutManager.handleNodeShiftingFromBelow();
        GraphLayoutManager.resolveOverlaps(6);
        GraphLayoutManager.centerGraph(graph, 7);
    }

    public static int calculateDepth(ResearchNode node) {
        return GraphLayoutManager._calculateDepth(node, 0);
    }

    public static Point centerOf2Nodes(ResearchNode node1, ResearchNode node2) {
        return new Point((node1.getX() + node2.getX() + 20) / 2, (node1.getY() + node2.getY() + 24) / 2);
    }

    public static Point centerOf2Nodes(List<ResearchNode> nodes) {
        int MIN_X = nodes.stream().mapToInt(AbstractWidget::getX).min().orElse(0);
        int MAX_X = nodes.stream().mapToInt(AbstractWidget::getX).max().orElse(0) + 20;
        int MIN_Y = nodes.stream().mapToInt(AbstractWidget::getY).min().orElse(0);
        int MAX_Y = nodes.stream().mapToInt(AbstractWidget::getY).max().orElse(0) + 24;
        return new Point((MIN_X + MAX_X) / 2, (MIN_Y + MAX_Y) / 2);
    }

    public static int widthOf(List<ResearchNode> nodes) {
        return nodes.size() * 30 - 10;
    }

    private static int _calculateDepth(ResearchNode node, int depth) {
        if (node != null) {
            if (node.getParents().isEmpty()) {
                return depth;
            }
            int maxDepth = depth;
            for (ResearchNode parent : node.getParents()) {
                maxDepth = Math.max(maxDepth, GraphLayoutManager._calculateDepth(parent, depth + 1));
            }
            return maxDepth;
        }
        return depth;
    }

    private static void _addLeftToLayer(int layer, ResearchNode node) {
        ((List)layerMap.computeIfAbsent(layer, k -> new ArrayList())).addFirst(node);
        nodeLayerMap.put(node, layer);
    }

    private static void _addRightToLayer(int layer, ResearchNode node) {
        ((List)layerMap.computeIfAbsent(layer, k -> new ArrayList())).addLast(node);
        nodeLayerMap.put(node, layer);
    }

    private static void calculateLayers(ResearchGraph graph, ResearchNode node) {
        for (ResearchNode gNode : graph.nodes().values()) {
            if (gNode == null) continue;
            GraphLayoutManager._addRightToLayer(GraphLayoutManager.calculateDepth(gNode), gNode);
        }
    }

    private static void positionNodesInLayers(int startX, int startY) {
        Researchd.debug("Layout", "Step 1 - Positioning nodes in layers");
        for (Map.Entry layer : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer.getValue()) {
                node.setYExt(startY + (Integer)layer.getKey() * 44);
                node.setXExt(startX + (((List)layer.getValue()).indexOf((Object)node) + 1) * 30);
                Researchd.debug("Layout", "Node@1: " + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer.getKey()) + " X: " + node.getX() + " Y: " + node.getY());
            }
        }
    }

    private static void centerNodesBasedOnLayers() {
        Researchd.debug("Layout", "Step 2 - Repositioning nodes in layers");
        int _maxNodes = 0;
        for (List nodesInLayer : layerMap.values()) {
            _maxNodes = Math.max(_maxNodes, nodesInLayer.size());
        }
        int _centerX = _maxNodes * 30 / 2;
        IntIterator intIterator = layerMap.keySet().iterator();
        while (intIterator.hasNext()) {
            int layerNum = (Integer)intIterator.next();
            List nodesInLayer = (List)layerMap.get(layerNum);
            int totalWidth = nodesInLayer.size() * 20 + (nodesInLayer.size() - 1) * 10;
            int startX = _centerX - totalWidth / 2;
            for (int i = 0; i < nodesInLayer.size(); ++i) {
                ResearchNode node = (ResearchNode)((Object)nodesInLayer.get(i));
                node.setXExt(startX + i * 30);
            }
        }
        for (Map.Entry layer : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer.getValue()) {
                Researchd.debug("Layout", "Node@2: " + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer.getKey()) + " X: " + node.getX() + " Y: " + node.getY());
            }
        }
    }

    private static void sortNodesBasedOnParents() {
        Object layer2;
        Researchd.debug("Layout", "Step 2.5 - Sorting nodes based on parents");
        ArrayList layerNumbers = new ArrayList(layerMap.keySet());
        if (layerNumbers.size() < 3) {
            return;
        }
        layerNumbers.sort(Comparator.naturalOrder());
        ObjectIterator objectIterator = layerNumbers.iterator();
        while (objectIterator.hasNext() && layerNumbers.indexOf(layer2 = (Integer)objectIterator.next()) != layerNumbers.size() - 1) {
            int nextLayer = (Integer)layerNumbers.get(layerNumbers.indexOf(layer2) + 1);
            Researchd.debug("Layout", "Sorting layer: " + ((Integer)layer2 + 1));
            List layerNodes = (List)layerMap.get(layer2);
            HashMap<ResearchNode, UniqueArray> subsequentChildrenMap = new HashMap<ResearchNode, UniqueArray>();
            UniqueArray allSubsequentChildren = new UniqueArray();
            for (ResearchNode node : layerNodes) {
                Researchd.debug("Layout", "Checking: " + String.valueOf(node.getInstance().getResearch()));
                UniqueArray<ResearchNode> children = node.getChildren();
                UniqueArray subsequentChildren = children.stream().filter(child -> child != null && child.getLayer() == node.getLayer() + 1).sorted(Comparator.comparingInt(AbstractWidget::getX)).collect(Collectors.toCollection(UniqueArray::new));
                allSubsequentChildren.addAll((Collection)subsequentChildren);
                subsequentChildrenMap.put(node, subsequentChildren);
            }
            int currentNodeIdx = 0;
            int firstNodeX = ((List)layerMap.get(nextLayer)).stream().mapToInt(AbstractWidget::getX).min().orElse(0);
            for (ResearchNode node : layerNodes) {
                UniqueArray subsequentChildren = (UniqueArray)subsequentChildrenMap.get((Object)node);
                if (subsequentChildren.isEmpty()) continue;
                for (ResearchNode child2 : subsequentChildren) {
                    int newX = firstNodeX + currentNodeIdx * 30;
                    child2.setXExt(newX);
                    ++currentNodeIdx;
                }
            }
        }
        for (Object layer2 : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer2.getValue()) {
                Researchd.debug("Layout", "Node@2.5: " + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer2.getKey()) + " X: " + node.getX() + " Y: " + node.getY());
            }
        }
    }

    private static void handleNodeShiftingFromAbove() {
        Researchd.debug("Layout", "Step 3 - Node shifting from above");
        ArrayList layerNumbers = new ArrayList(layerMap.keySet());
        layerNumbers.sort(Comparator.naturalOrder());
        for (Object layer : layerNumbers) {
            List nodes = (List)layerMap.get(layer);
            for (ResearchNode node : nodes) {
                if (!node.shouldMove()) continue;
                Researchd.debug("Layout", "Checking: " + String.valueOf(node.getInstance().getResearch()));
                UniqueArray<ResearchNode> parents = node.getParents();
                UniqueArray<ResearchNode> children = node.getChildren();
                UniqueArray subsequentChildren = children.stream().filter(child -> child != null && child.getLayer() == node.getLayer() + 1).sorted(Comparator.comparingInt(AbstractWidget::getX)).collect(Collectors.toCollection(UniqueArray::new));
                UniqueArray parentsOnLayerAbove = parents.stream().filter(parent -> parent != null && parent.getLayer() == node.getLayer() + 1).sorted(Comparator.comparingInt(AbstractWidget::getX)).collect(Collectors.toCollection(UniqueArray::new));
                if (subsequentChildren.isEmpty() || !subsequentChildren.stream().filter(child -> child != null && child.getParents().size() != 1).toList().isEmpty()) continue;
                node.setXExt(GraphLayoutManager.centerOf2Nodes((List<ResearchNode>)subsequentChildren).x - 10);
                subsequentChildren.forEach(child -> {
                    if (child != null) {
                        child.lockNodeTo(node);
                    }
                });
                Researchd.debug("Layout", "Shifted node: " + String.valueOf(node.getInstance().getResearch()) + " to center of its children: " + subsequentChildren.stream().map(ResearchNode::getInstance).map(instance -> instance.getResearch().toString()).collect(Collectors.joining(", ")));
            }
        }
        for (Object layer : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer.getValue()) {
                Researchd.debug("Layout", "Node@3: " + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer.getKey()) + " X: " + node.getX() + " Y: " + node.getY() + " Pos locks: " + node.getPositionLocks().size());
            }
        }
    }

    private static void handleNodeShiftingFromBelow() {
        Researchd.debug("Layout", "Step 5 - Node shifting from below");
        ArrayList layerNumbers = new ArrayList(layerMap.keySet());
        layerNumbers.sort((a, b) -> Integer.compare(b, a));
        for (Object layer : layerNumbers) {
            List nodes = (List)layerMap.get(layer);
            for (ResearchNode node : nodes) {
                if (!node.shouldMove()) continue;
                Researchd.debug("Layout", "Checking: " + String.valueOf(node.getInstance().getResearch()));
                UniqueArray<ResearchNode> parents = node.getParents();
                UniqueArray<ResearchNode> children = node.getChildren();
                HashMap<Integer, UniqueArray> parentToSubsequentChildren = new HashMap<Integer, UniqueArray>();
                UniqueArray parentsOnLayerAbove = parents.stream().filter(parent -> parent != null && parent.getLayer() == node.getLayer() - 1).collect(Collectors.toCollection(UniqueArray::new));
                int _parentIndex = 0;
                for (ResearchNode parent2 : parents) {
                    if (parent2 == null) continue;
                    UniqueArray _children = new UniqueArray(parent2.getChildren());
                    UniqueArray _subsequentChildren = new UniqueArray(_children.stream().filter(child -> child != null && child.getLayer() == parent2.getLayer() - 1).toList());
                    parentToSubsequentChildren.put(_parentIndex, _subsequentChildren);
                    ++_parentIndex;
                }
                if (!children.isEmpty()) continue;
            }
        }
        for (Object layer : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer.getValue()) {
                Researchd.debug("Layout", "Node@4: " + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer.getKey()) + " X: " + node.getX() + " Y: " + node.getY() + " Pos locks: " + node.getPositionLocks().size());
            }
        }
    }

    private static void resolveOverlaps(int step) {
        Researchd.debug("Layout", "Step %d - Resolving overlaps".formatted(step));
        for (Map.Entry layer : layerMap.int2ObjectEntrySet()) {
            for (ResearchNode node : (List)layer.getValue()) {
                Researchd.debug("Layout", "Node@%d: ".formatted(step) + String.valueOf(node.getInstance().getResearch()) + " Layer: " + String.valueOf(layer.getKey()) + " X: " + node.getX() + " Y: " + node.getY() + " Pos locks: " + node.getPositionLocks().size());
            }
        }
    }

    private static void centerGraph(ResearchGraph graph, int step) {
        Researchd.debug("Layout", "Step %d - Centering graph".formatted(step));
        ResearchNode root = graph.rootNode();
        ResearchScreen screen = Spaghetti.tryGetResearchScreen();
        if (screen == null) {
            Researchd.debug("Layout", "Cannot center graph, ResearchScreen is not open.");
            return;
        }
        ResearchGraphWidget graphWidget = screen.getResearchGraphWidget();
        int width = graphWidget.getWidth();
        int height = graphWidget.getHeight();
        int dx = (width - 20) / 2 - root.getX() + screen.getSelectedResearchWidget().getWidth();
        int dy = (height - 24) / 2 - root.getY();
        for (ResearchNode node : graph.nodes().values()) {
            node.translate(dx, dy);
            Researchd.debug("Layout", "Node@%d: ".formatted(step) + String.valueOf(node.getInstance().getResearch()) + " Layer: " + node.getLayer() + " X: " + node.getX() + " Y: " + node.getY() + " Pos locks: " + node.getPositionLocks().size());
        }
    }
}

