/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.client.screens.research.graph.ResearchNode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;

public class GraphStateManager {
    private static final GraphStateManager INSTANCE = new GraphStateManager();
    private final Map<ResourceKey<Research>, NodeState> lastSessionState = new HashMap<ResourceKey<Research>, NodeState>();
    private ResourceKey<Research> lastGraphRoot = null;

    private GraphStateManager() {
    }

    public static GraphStateManager getInstance() {
        return INSTANCE;
    }

    public void saveLastSessionState(ResearchGraph graph) {
        if (graph == null || graph.nodes().isEmpty() || graph.rootNode() == null) {
            Researchd.debug("Graph State Cache", "No graph to save state for");
            return;
        }
        this.clearState();
        this.lastGraphRoot = graph.rootNode().getInstance().getKey();
        for (ResearchNode node : graph.nodes().values()) {
            ResourceKey<Research> key = node.getInstance().getKey();
            this.lastSessionState.put(key, new NodeState(node.getX(), node.getY()));
        }
        Researchd.debug("Graph State Cache", "Saved last session state for graph: " + String.valueOf(this.lastGraphRoot));
    }

    public boolean tryRestoreLastSessionState(ResearchGraph graph) {
        if (graph == null || graph.nodes().isEmpty() || graph.rootNode() == null || this.lastGraphRoot == null || this.lastSessionState.isEmpty()) {
            Researchd.debug("Graph State Cache", "No previous session state to restore");
            return false;
        }
        if (!graph.rootNode().getInstance().is(this.lastGraphRoot)) {
            Researchd.debug("Graph State Cache", "Graph root has changed, not restoring last session state");
            return false;
        }
        Researchd.debug("Graph State Cache", "Restoring last session");
        for (ResearchNode node : graph.nodes().values()) {
            ResourceKey<Research> key = node.getInstance().getKey();
            NodeState state = this.lastSessionState.get(key);
            if (state == null) continue;
            node.setXExt(state.x);
            node.setYExt(state.y);
        }
        return true;
    }

    public void clearState() {
        this.lastSessionState.clear();
        this.lastGraphRoot = null;
    }

    private record NodeState(int x, int y) {
    }
}

