/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreenWidget;
import com.portingdeadmods.researchd.client.screens.research.graph.GraphLayoutManager;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.ResearchHead;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;

public class ResearchNode
extends AbstractWidget {
    private final UniqueArray<ResearchNode> parents;
    private final UniqueArray<ResearchNode> children;
    private final UniqueArray<ResearchNode> positionLocks;
    private boolean doMovementLogic;
    private ResearchInstance instance;
    private final UniqueArray<ResearchHead> inputs;
    private final UniqueArray<ResearchHead> outputs;
    private boolean rootNode;
    public ResearchGraph graph;

    public void fetchInstanceFromTeam() {
        ResearchTeam team = ClientResearchTeamHelper.getTeam();
        ResearchInstance updatedInstance = team.getResearches().get(this.instance.getKey());
        if (updatedInstance != null) {
            this.instance = updatedInstance;
        }
    }

    public ResearchNode(ResearchInstance instance) {
        super(0, 0, 20, 24, CommonComponents.EMPTY);
        this.instance = instance;
        this.children = new UniqueArray();
        this.parents = new UniqueArray();
        this.positionLocks = new UniqueArray();
        this.inputs = new UniqueArray();
        this.outputs = new UniqueArray();
        this.rootNode = false;
        this.doMovementLogic = true;
    }

    public void setHovered(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        this.isHovered = guiGraphics.containsPointInScissor(mouseX, mouseY) && mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public void addChild(ResearchNode child) {
        this.children.addLast((Object)child);
    }

    public void addParent(ResearchNode parent) {
        this.parents.addLast((Object)parent);
    }

    public void addPositionLock(ResearchNode positionLock) {
        this.positionLocks.add((Object)positionLock);
    }

    public boolean shouldMove() {
        return this.doMovementLogic;
    }

    public void lockNodeTo(ResearchNode node) {
        this.addPositionLock(node);
        this.doMovementLogic = false;
    }

    public void lockNode() {
        this.doMovementLogic = false;
    }

    public Integer getLayer() {
        if (GraphLayoutManager.nodeLayerMap.get((Object)this) == null) {
            return -1;
        }
        return GraphLayoutManager.nodeLayerMap.get((Object)this);
    }

    public UniqueArray<ResearchNode> getChildren() {
        return this.children;
    }

    public UniqueArray<ResearchNode> getParents() {
        return this.parents;
    }

    public UniqueArray<ResearchNode> getPositionLocks() {
        return this.positionLocks;
    }

    public ResearchInstance getInstance() {
        return this.instance;
    }

    public UniqueArray<ResearchHead> getInputs() {
        return this.inputs;
    }

    public UniqueArray<ResearchHead> getOutputs() {
        return this.outputs;
    }

    public void refreshHeads() {
        if (this.graph != null) {
            Collection<ResearchNode> nodes = this.graph.nodes().values();
            this.inputs.clear();
            this.inputs.addAll(ResearchHead.inputsOf(this, nodes));
            this.outputs.clear();
            this.outputs.addAll(ResearchHead.outputsOf(this, nodes));
        }
    }

    public boolean isRootNode() {
        return this.rootNode;
    }

    public void setRootNode(boolean rootNode) {
        this.rootNode = rootNode;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, this.instance, this.getX(), this.getY(), mouseX, mouseY);
        this.refreshHeads();
        for (ResearchHead input : this.inputs) {
            input.render(guiGraphics);
        }
        for (ResearchHead output : this.outputs) {
            output.render(guiGraphics);
        }
    }

    public String toString() {
        return "ResearchNode{next=" + String.valueOf(this.children) + "}";
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setXExt(int x1) {
        int dx = x1 - this.getX();
        this.translate(dx, 0);
    }

    public void setYExt(int y1) {
        int dy = y1 - this.getY();
        this.translate(0, dy);
    }

    public void translate(int dx, int dy) {
        this.setX(this.getX() + dx);
        this.setY(this.getY() + dy);
        this.refreshHeads();
    }

    public void downStream(int dx, int dy) {
        for (ResearchNode child : this.children) {
            child.translate(dx, dy);
            child.downStream(dx, dy);
        }
    }

    public void downStreamSetX(int x) {
        int dx = x - this.getX();
        this.downStream(dx, 0);
    }

    public void downStreamSetY(int y) {
        int dy = y - this.getY();
        this.downStream(0, dy);
    }
}

