/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph.lines;

import com.portingdeadmods.researchd.Researchd;
import java.awt.Point;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;

public class LineSegment
implements Renderable {
    private final Point start;
    private final Point end;

    public LineSegment(Point start, Point end) {
        if (start.x != end.x && start.y != end.y) {
            Researchd.LOGGER.error("LineSegment must be either vertical or horizontal. Provided: (%d, %d) - (%d, %d)".formatted(start.x, start.y, end.x, end.y), (Throwable)new IllegalArgumentException("LineSegment must be either vertical or horizontal. Provided: (%d, %d) - (%d, %d)".formatted(start.x, start.y, end.x, end.y)));
            this.start = start;
            this.end = new Point(start.x, end.y);
        } else {
            this.start = start;
            this.end = end;
        }
    }

    public Point a() {
        return this.start;
    }

    public Point b() {
        return this.end;
    }

    public boolean isVertical() {
        return this.start.x == this.end.x;
    }

    public boolean isHorizontal() {
        return this.start.y == this.end.y;
    }

    public void render(GuiGraphics guiGraphics, int color) {
        if (this.isVertical()) {
            guiGraphics.vLine(this.start.x, Math.min(this.start.y, this.end.y), Math.max(this.start.y, this.end.y), color);
        } else if (this.isHorizontal()) {
            guiGraphics.hLine(Math.min(this.start.x, this.end.x), Math.max(this.start.x, this.end.x), this.start.y, color);
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v) {
        this.render(guiGraphics, -1);
    }
}

