/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph.lines;

import com.portingdeadmods.researchd.client.screens.research.graph.lines.LineSegment;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.PotentialOverlap;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.ResearchHead;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchLine
implements Renderable {
    private final LinkedList<Point> points;
    @Nullable
    private ResearchHead startHead;
    @Nullable
    private ResearchHead endHead;
    private int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);

    private ResearchLine() {
        this.points = new LinkedList();
    }

    public static ResearchLine start(Point start) {
        ResearchLine line = new ResearchLine();
        line.points.add(start);
        return line;
    }

    public static ResearchLine start(ResearchHead start) {
        ResearchLine line = new ResearchLine();
        line.points.add(start.getConnectionPoint());
        line.startHead = start;
        return line;
    }

    public static ResearchLine start(int x, int y) {
        return ResearchLine.start(new Point(x, y));
    }

    public ResearchLine setEndHead(@NotNull ResearchHead endHead) {
        this.endHead = endHead;
        return this;
    }

    public ResearchLine setStartHead(@NotNull ResearchHead startHead) {
        this.startHead = startHead;
        return this;
    }

    @Nullable
    public ResearchHead getStartHead() {
        return this.startHead;
    }

    @Nullable
    public ResearchHead getEndHead() {
        return this.endHead;
    }

    public ResearchLine then(Point point) {
        this.points.add(point);
        return this;
    }

    public ResearchLine then(int x, int y) {
        return this.then(new Point(x, y));
    }

    public ResearchLine horizontal(int dx) {
        Point last = this.points.getLast();
        return this.then(last.x + dx, last.y);
    }

    public ResearchLine vertical(int dy) {
        Point last = this.points.getLast();
        return this.then(last.x, last.y + dy);
    }

    public ResearchLine shift(int index, int delta) {
        boolean isVertical;
        if (this.points.size() < index || index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds for shifting: " + index);
        }
        if (index == 0 || index == this.points.size() - 2) {
            throw new IllegalArgumentException("Cannot shift a line linked to a ResearchHead");
        }
        Point prev = this.points.get(index - 1);
        Point a = this.points.get(index);
        Point b = this.points.get(index + 1);
        Point next = this.points.get(index + 2);
        boolean bl = isVertical = a.x == b.x;
        if (isVertical) {
            if (prev.y != a.y || next.y != b.y) {
                throw new IllegalStateException("The shift would create a discontinuity in the line");
            }
            this.points.set(index, new Point(a.x + delta, a.y));
            this.points.set(index + 1, new Point(b.x + delta, b.y));
        } else {
            if (prev.x != a.x || next.x != b.x) {
                throw new IllegalStateException("The shift would create a discontinuity in the line");
            }
            this.points.set(index, new Point(a.x, a.y + delta));
            this.points.set(index + 1, new Point(b.x, b.y + delta));
        }
        return this;
    }

    public ResearchLine shiftAndCreate(int index, int delta) {
        boolean isVertical;
        if (this.points.size() < index || index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds for shifting: " + index);
        }
        boolean duplicateA = false;
        boolean duplicateB = false;
        if (index == 0) {
            duplicateA = true;
        }
        if (index == this.points.size() - 2) {
            duplicateB = true;
        }
        Point a = this.points.get(index);
        Point b = this.points.get(index + 1);
        boolean bl = isVertical = a.x == b.x;
        if (isVertical) {
            if (!duplicateA) {
                Point prev = this.points.get(index - 1);
                if (prev.y != a.y) {
                    duplicateA = true;
                }
            }
            if (!duplicateB) {
                Point next = this.points.get(index + 2);
                if (next.y != b.y) {
                    duplicateB = true;
                }
            }
        } else {
            if (!duplicateA) {
                Point prev = this.points.get(index - 1);
                if (prev.x != a.x) {
                    duplicateA = true;
                }
            }
            if (!duplicateB) {
                Point next = this.points.get(index + 2);
                if (next.x != b.x) {
                    duplicateB = true;
                }
            }
        }
        if (duplicateA) {
            this.points.add(this.points.indexOf(a), new Point(a.x, a.y));
        }
        if (duplicateB) {
            this.points.add(this.points.indexOf(b) + 1, new Point(b.x, b.y));
        }
        if (isVertical) {
            a.x += delta;
            b.x += delta;
        } else {
            a.y += delta;
            b.y += delta;
        }
        return this;
    }

    public static ResearchLine createLConnection(Point start, Point end, boolean verticalFirst) {
        if (verticalFirst) {
            return ResearchLine.start(start).then(start.x, end.y).then(end);
        }
        return ResearchLine.start(start).then(end.x, start.y).then(end);
    }

    public static ResearchLine createLConnection(ResearchHead start, ResearchHead end, boolean verticalFirst) {
        return ResearchLine.createLConnection(start.getConnectionPoint(), end.getConnectionPoint(), verticalFirst).setStartHead(start).setEndHead(end);
    }

    public static ResearchLine createSConnection(Point start, Point end, int verticalOffset) {
        if (verticalOffset < 0 || verticalOffset > Math.abs(start.y - end.y)) {
            throw new IllegalArgumentException("Vertical offset must be between 0 and the vertical distance between the points");
        }
        if (start.y < end.y) {
            return ResearchLine.start(start).then(start.x, start.y + verticalOffset).then(end.x, start.y + verticalOffset).then(end);
        }
        return ResearchLine.start(start).then(start.x, start.y - verticalOffset).then(end.x, start.y - verticalOffset).then(end);
    }

    public static ResearchLine createSConnection(ResearchHead start, ResearchHead end, int verticalOffset) {
        return ResearchLine.createSConnection(start.getConnectionPoint(), end.getConnectionPoint(), verticalOffset).setStartHead(start).setEndHead(end);
    }

    public static ResearchLine direct(ResearchHead start, ResearchHead end) {
        return ResearchLine.start(start.getConnectionPoint()).then(end.getConnectionPoint()).setStartHead(start).setEndHead(end);
    }

    public static ResearchLine connectNodes(Point outputPoint, Point inputPoint, boolean verticalFirst) {
        return ResearchLine.createLConnection(outputPoint, inputPoint, verticalFirst);
    }

    public void render(@NotNull GuiGraphics guiGraphics) {
        if (this.points.size() < 2) {
            return;
        }
        Point prev = this.points.getFirst();
        for (Point curr : this.points.stream().skip(1L).toList()) {
            new LineSegment(prev, curr).render(guiGraphics, this.getColor());
            prev = curr;
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v) {
        this.render(guiGraphics);
    }

    public LinkedList<Point> getPoints() {
        return new LinkedList<Point>(this.points);
    }

    public ResearchLine translate(int dx, int dy) {
        this.points.replaceAll(p -> new Point(p.x + dx, p.y + dy));
        return this;
    }

    public Point getStart() {
        return this.points.getFirst();
    }

    public Point getEnd() {
        return this.points.getLast();
    }

    public Set<PotentialOverlap> getOverlaps(ResearchLine other) {
        return ResearchLine.getOverlaps(this, other);
    }

    private static List<LineSegment> getLineSegments(ResearchLine line) {
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
        List points = line.getPoints().stream().toList();
        for (int i = 0; i < points.size() - 1; ++i) {
            segments.add(new LineSegment((Point)points.get(i), (Point)points.get(i + 1)));
        }
        return segments;
    }

    public static Set<PotentialOverlap> getOverlaps(ResearchLine line1, ResearchLine line2) {
        HashSet<PotentialOverlap> overlaps = new HashSet<PotentialOverlap>();
        List<LineSegment> segments1 = ResearchLine.getLineSegments(line1);
        List<LineSegment> segments2 = ResearchLine.getLineSegments(line2);
        for (LineSegment seg1 : segments1) {
            for (LineSegment seg2 : segments2) {
                PotentialOverlap overlap = PotentialOverlap.of(seg1, seg2);
                if (overlap == null) continue;
                overlaps.add(overlap);
            }
        }
        return overlaps;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

