/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.widgets;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.client.cache.ResearchGraphCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreenWidget;
import com.portingdeadmods.researchd.client.screens.research.graph.GraphLayoutManager;
import com.portingdeadmods.researchd.client.screens.research.graph.GraphStateManager;
import com.portingdeadmods.researchd.client.screens.research.graph.ResearchNode;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.PotentialOverlap;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.ResearchHead;
import com.portingdeadmods.researchd.client.screens.research.graph.lines.ResearchLine;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ResearchGraphWidget
extends AbstractWidget {
    public static final int LEFT_MARGIN_WIDTH = 174;
    @Nullable
    private ResearchGraph graph;
    private final Map<ResearchNode, ArrayList<ResearchLine>> researchLines;
    private final ResearchScreen researchScreen;
    private final float ROOT_NODE_SCALING = 1.75f;

    public ResearchGraphWidget(ResearchScreen researchScreen, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.researchScreen = researchScreen;
        this.researchLines = new HashMap<ResearchNode, ArrayList<ResearchLine>>();
    }

    public void setGraph(ResearchGraph graph) {
        if (this.graph != graph) {
            this.graph = graph;
            this.researchLines.clear();
            if (graph == null || graph.nodes().isEmpty()) {
                return;
            }
            boolean layoutRestored = GraphStateManager.getInstance().tryRestoreLastSessionState(graph);
            if (!layoutRestored) {
                GraphLayoutManager.applyLayout(graph, this.getX() + 10, this.getY() + 10);
            }
            for (ResearchNode node : graph.nodes().values()) {
                node.refreshHeads();
            }
            int baseX = this.graph.rootNode().getX();
            int baseY = this.graph.rootNode().getY();
            int centerX = baseX + 10;
            int centerY = baseY + 12;
            this.translate(this.getWidth() / 2 - centerX + 174, this.getHeight() / 2 - centerY);
            this.calculateLines();
        }
    }

    private void calculateLines() {
        this.researchLines.clear();
        Researchd.debug("Research lines", "Calculating connection lines for graph with ", this.graph.nodes().size(), " nodes.");
        if (this.graph == null) {
            Researchd.debug("Research lines", "Graph is null, skipping line calculation.");
            return;
        }
        if (this.graph.nodes().isEmpty()) {
            Researchd.debug("Research lines", "No nodes in graph, skipping line calculation.");
            return;
        }
        ArrayList<ResearchNode> sortedNodes = new ArrayList<ResearchNode>(this.graph.nodes().values());
        sortedNodes.sort(Comparator.comparingInt(AbstractWidget::getY).reversed().thenComparingInt(AbstractWidget::getX));
        Researchd.debug("Research lines", "Sorted ", sortedNodes.size(), " nodes for processing");
        ArrayList<ResearchLine> allLines = new ArrayList<ResearchLine>();
        HashSet<Integer> verticalPathXCoords = new HashSet<Integer>();
        HashSet<ResearchHead> usedOutputHeads = new HashSet<ResearchHead>();
        HashSet<ResearchHead> usedInputHeads = new HashSet<ResearchHead>();
        for (ResearchNode parent : sortedNodes) {
            Researchd.debug("Research lines", "Processing parent node: ", parent.getInstance().getKey().location());
            ArrayList<ResearchLine> nodeLines = new ArrayList<ResearchLine>();
            HashMap<Integer, List> childrenByLayer = new HashMap<Integer, List>();
            for (ResearchNode child : parent.getChildren()) {
                if (!this.graph.nodes().containsValue((Object)child)) continue;
                childrenByLayer.computeIfAbsent(GraphLayoutManager.calculateDepth(child), k -> new ArrayList()).add(child);
            }
            Researchd.debug("Research lines", "Parent has ", childrenByLayer.size(), " child layers with total children: ", parent.getChildren().size());
            for (Map.Entry entry : childrenByLayer.entrySet()) {
                List layerChildren = (List)entry.getValue();
                Researchd.debug("Research lines", "Processing layer ", entry.getKey(), " with ", layerChildren.size(), " children");
                layerChildren.sort(Comparator.comparingInt(AbstractWidget::getX));
                boolean preferVerticalFirst = (double)(parent.getX() + 10) < layerChildren.stream().mapToInt(n -> n.getX() + 10).average().orElse(0.0);
                Researchd.debug("Research lines", "Path style for this layer: ", preferVerticalFirst ? "vertical-first" : "horizontal-first");
                List<ResearchHead> availableOutputHeads = parent.getOutputs().stream().filter(head -> !usedOutputHeads.contains(head)).sorted(Comparator.comparingInt(ResearchHead::getX)).collect(Collectors.toList());
                Researchd.debug("Research lines", "Available output heads: ", availableOutputHeads.size(), " out of ", parent.getOutputs().size());
                for (int i = 0; i < layerChildren.size(); ++i) {
                    ResearchNode child = (ResearchNode)((Object)layerChildren.get(i));
                    Researchd.debug("Research lines", "Processing child ", i + 1, "/", layerChildren.size(), ": ", child.getInstance().getKey().location());
                    Researchd.debug("Research lines", "Total input heads: ", child.getInputs().size());
                    List<ResearchHead> availableInputHeads = child.getInputs().stream().filter(head -> !usedInputHeads.contains(head)).sorted(Comparator.comparingInt(ResearchHead::getX)).collect(Collectors.toList());
                    Researchd.debug("Research lines", "Available input heads: ", availableInputHeads.size(), " out of ", child.getInputs().size());
                    Pair<ResearchHead, ResearchHead> bestHeads = this.findBestHeadPairByPosition(parent, child, availableOutputHeads, availableInputHeads, i, layerChildren.size(), usedOutputHeads, usedInputHeads);
                    Researchd.debug("Research lines", "Selected head pair - Output: ", bestHeads.left() != null ? "found" : "null", ", Input: ", bestHeads.right() != null ? "found" : "null");
                    usedOutputHeads.add((ResearchHead)bestHeads.left());
                    usedInputHeads.add((ResearchHead)bestHeads.right());
                    availableOutputHeads.remove(bestHeads.left());
                    if (bestHeads.left() != null && bestHeads.right() != null) {
                        Researchd.debug("Research lines", "Generating optimal path between connection points");
                        ResearchLine bestLine = this.generateOptimalPath(((ResearchHead)bestHeads.left()).getConnectionPoint(), ((ResearchHead)bestHeads.right()).getConnectionPoint(), allLines, verticalPathXCoords, preferVerticalFirst);
                        Researchd.debug("Research lines", "Generated path with ", bestLine.getPoints().size(), " points");
                        int verticalSegments = 0;
                        for (int j = 0; j < bestLine.getPoints().size() - 1; ++j) {
                            Point p1 = bestLine.getPoints().get(j);
                            Point p2 = bestLine.getPoints().get(j + 1);
                            if (p1.x != p2.x) continue;
                            verticalPathXCoords.add(p1.x);
                            ++verticalSegments;
                        }
                        Researchd.debug("Research lines", "Added ", verticalSegments, " vertical segments to path tracking");
                        nodeLines.add(bestLine);
                        allLines.add(bestLine);
                        continue;
                    }
                    Researchd.debug("Research lines", "Skipping line generation due to null heads");
                }
            }
            if (!nodeLines.isEmpty()) {
                this.researchLines.put(parent, nodeLines);
                Researchd.debug("Research lines", "Added ", nodeLines.size(), " lines for parent node");
                continue;
            }
            Researchd.debug("Research lines", "No lines generated for parent node");
        }
        Researchd.debug("Research lines", "Line calculation complete. Generated ", this.researchLines.size(), " line groups with total lines: ", allLines.size());
    }

    private Pair<ResearchHead, ResearchHead> findBestHeadPairByPosition(ResearchNode parent, ResearchNode child, List<ResearchHead> availableOutputHeads, List<ResearchHead> availableInputHeads, int childIndex, int totalChildren, Set<ResearchHead> usedOutputHeads, Set<ResearchHead> usedInputHeads) {
        if (availableOutputHeads.isEmpty() || availableInputHeads.isEmpty()) {
            if (availableOutputHeads.isEmpty() && !parent.getOutputs().isEmpty()) {
                availableOutputHeads = new ArrayList<ResearchHead>((Collection<ResearchHead>)parent.getOutputs());
                availableOutputHeads.removeIf(usedOutputHeads::contains);
                if (availableOutputHeads.isEmpty()) {
                    availableOutputHeads = new ArrayList<ResearchHead>((Collection<ResearchHead>)parent.getOutputs());
                }
            }
            if (availableInputHeads.isEmpty() && !child.getInputs().isEmpty()) {
                availableInputHeads = new ArrayList<ResearchHead>((Collection<ResearchHead>)child.getInputs());
                availableInputHeads.removeIf(usedInputHeads::contains);
                if (availableInputHeads.isEmpty()) {
                    availableInputHeads = new ArrayList<ResearchHead>((Collection<ResearchHead>)child.getInputs());
                }
            }
        }
        if (availableOutputHeads.isEmpty() || availableInputHeads.isEmpty()) {
            ResearchHead outputHead = !parent.getOutputs().isEmpty() ? (ResearchHead)parent.getOutputs().getFirst() : null;
            ResearchHead inputHead = !child.getInputs().isEmpty() ? (ResearchHead)child.getInputs().getFirst() : null;
            return Pair.of((Object)outputHead, (Object)inputHead);
        }
        availableOutputHeads.sort(Comparator.comparingInt(ResearchHead::getX));
        availableInputHeads.sort(Comparator.comparingInt(ResearchHead::getX));
        ResearchHead inputHead = availableInputHeads.getFirst();
        ResearchHead outputHead = availableOutputHeads.stream().min(Comparator.comparingInt(head -> Math.abs(head.getX() - inputHead.getX()))).orElse(availableOutputHeads.getFirst());
        return Pair.of((Object)outputHead, (Object)inputHead);
    }

    private ResearchLine generateOptimalPath(Point start, Point end, List<ResearchLine> existingLines, Set<Integer> verticalPathXCoords, boolean preferVerticalFirst) {
        double customScore;
        ResearchLine customPath;
        ArrayList<ResearchLine> candidates = new ArrayList<ResearchLine>();
        if (start.x == end.x) {
            candidates.add(ResearchLine.start(start).then(end));
        }
        candidates.add(ResearchLine.createLConnection(start, end, true));
        candidates.add(ResearchLine.createLConnection(start, end, false));
        int verticalDistance = Math.abs(end.y - start.y);
        if (verticalDistance > 24) {
            try {
                candidates.add(ResearchLine.createSConnection(start, end, verticalDistance / 3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                candidates.add(ResearchLine.createSConnection(start, end, verticalDistance / 2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (int x : verticalPathXCoords) {
            if (x <= Math.min(start.x, end.x) || x >= Math.max(start.x, end.x)) continue;
            try {
                ResearchLine path = ResearchLine.start(start).then(start.x, start.y).then(x, start.y).then(x, end.y).then(end.x, end.y).then(end);
                candidates.add(path);
            }
            catch (Exception exception) {}
        }
        ResearchLine bestPath = null;
        double bestScore = Double.MAX_VALUE;
        for (ResearchLine candidate : candidates) {
            double score = this.evaluatePath(candidate, existingLines, preferVerticalFirst);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestPath = candidate;
        }
        if (bestScore > 2.0 && !existingLines.isEmpty() && (customPath = this.findCustomPath(start, end, existingLines, verticalPathXCoords)) != null && (customScore = this.evaluatePath(customPath, existingLines, preferVerticalFirst)) < bestScore) {
            return customPath;
        }
        return bestPath != null ? bestPath : (ResearchLine)candidates.getFirst();
    }

    private double evaluatePath(ResearchLine path, List<ResearchLine> existingLines, boolean preferVerticalFirst) {
        double score = path.getPoints().size() - 1;
        LinkedList<Point> points = path.getPoints();
        if (points.size() >= 3) {
            boolean isFirstSegmentVertical;
            Point p1 = (Point)points.get(0);
            Point p2 = (Point)points.get(1);
            boolean bl = isFirstSegmentVertical = p1.x == p2.x;
            if (isFirstSegmentVertical != preferVerticalFirst) {
                score += 0.5;
            }
        }
        for (ResearchLine existingLine : existingLines) {
            Set<PotentialOverlap> overlaps = path.getOverlaps(existingLine);
            for (PotentialOverlap overlap : overlaps) {
                score += overlap.isOverlap() ? 2.0 : 1.0;
            }
            score += this.calculateProximityPenalty(path, existingLine);
        }
        return score;
    }

    private double calculateProximityPenalty(ResearchLine path1, ResearchLine path2) {
        double penalty = 0.0;
        LinkedList<Point> points1 = path1.getPoints();
        LinkedList<Point> points2 = path2.getPoints();
        for (int i = 0; i < points1.size() - 1; ++i) {
            Point a1 = (Point)points1.get(i);
            Point a2 = (Point)points1.get(i + 1);
            for (int j = 0; j < points2.size() - 1; ++j) {
                int xOverlap;
                int yOverlap;
                Point b1 = (Point)points2.get(j);
                Point b2 = (Point)points2.get(j + 1);
                if (a1.x == a2.x && b1.x == b2.x && Math.abs(a1.x - b1.x) < 5 && (yOverlap = Math.min(Math.max(a1.y, a2.y), Math.max(b1.y, b2.y)) - Math.max(Math.min(a1.y, a2.y), Math.min(b1.y, b2.y))) > 0) {
                    penalty += 0.5;
                }
                if (a1.y != a2.y || b1.y != b2.y || Math.abs(a1.y - b1.y) >= 5 || (xOverlap = Math.min(Math.max(a1.x, a2.x), Math.max(b1.x, b2.x)) - Math.max(Math.min(a1.x, a2.x), Math.min(b1.x, b2.x))) <= 0) continue;
                penalty += 0.5;
            }
        }
        return penalty;
    }

    private ResearchLine findCustomPath(Point start, Point end, List<ResearchLine> existingLines, Set<Integer> verticalPathXCoords) {
        int minX = Math.min(start.x, end.x);
        int maxX = Math.max(start.x, end.x);
        int width = maxX - minX;
        for (int i = 1; i <= 4; ++i) {
            ResearchLine path;
            double score;
            int midX = minX + width * i / 5;
            if (verticalPathXCoords.contains(midX) || !((score = this.evaluatePath(path = ResearchLine.start(start).then(midX, start.y).then(midX, end.y).then(end), existingLines, true)) < 2.0)) continue;
            return path;
        }
        int minY = Math.min(start.y, end.y);
        int maxY = Math.max(start.y, end.y);
        int midY = minY + (maxY - minY) / 2;
        for (int offset = -20; offset <= 20; offset += 10) {
            int midX = (start.x + end.x) / 2 + offset;
            ResearchLine path = ResearchLine.start(start).then(start.x, midY).then(midX, midY).then(midX, end.y).then(end);
            double score = this.evaluatePath(path, existingLines, true);
            if (!(score < 3.0)) continue;
            return path;
        }
        int quarterY = start.y + (end.y - start.y) / 3;
        int thirdX = start.x + (end.x - start.x) / 4;
        return ResearchLine.start(start).then(start.x, quarterY).then(thirdX, quarterY).then(thirdX, midY).then(end.x, midY).then(end.x, end.y).then(end);
    }

    public ResearchGraph getCurrentGraph() {
        return this.graph;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.graph == null || this.graph.nodes() == null) {
            return;
        }
        int w = 174;
        guiGraphics.enableScissor(w, 8, guiGraphics.guiWidth() - 8, guiGraphics.guiHeight() - 8);
        if (this.researchLines != null) {
            for (List list : this.researchLines.values()) {
                for (ResearchLine line : list) {
                    line.render(guiGraphics);
                }
            }
        }
        for (ResearchNode researchNode : this.graph.nodes().values()) {
            if (researchNode.isRootNode()) {
                int width = 20;
                int height = 24;
                float baseX = researchNode.getX();
                float baseY = researchNode.getY();
                float centerX = baseX + (float)width / 2.0f;
                float centerY = baseY + (float)height / 2.0f;
                int scaledX = (int)(centerX - (float)width * 1.75f / 2.0f);
                int scaledY = (int)(centerY - (float)height * 1.75f / 2.0f);
                researchNode.setHovered(guiGraphics, scaledX, scaledY, 35, 42, mouseX, mouseY);
                ResearchScreenWidget.renderResearchPanel(guiGraphics, researchNode.getInstance(), scaledX + 1, scaledY, mouseX, mouseY, 1.75f);
                continue;
            }
            researchNode.render(guiGraphics, mouseX, mouseY, v);
        }
        guiGraphics.disableScissor();
    }

    private void renderNode(ResearchNode node, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        node.render(guiGraphics, mouseX, mouseY, partialTick);
        for (ResearchNode childNode : node.getChildren()) {
            this.renderNode(childNode, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderNodeTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isHovered() || this.graph == null || this.graph.nodes() == null) {
            return;
        }
        for (ResearchNode node : this.graph.nodes().values()) {
            if (!node.isHovered()) continue;
            Minecraft mc = Minecraft.getInstance();
            if (SharedConstants.IS_RUNNING_IN_IDE && !ResearchScreen.hasControlDown()) {
                guiGraphics.renderComponentTooltip(mc.font, List.of(node.getInstance().getDisplayName((Level)mc.level), node.getInstance().getDescription((Level)mc.level), SharedConstants.IS_RUNNING_IN_IDE ? Component.literal((String)"Press Ctrl for debug info") : Component.empty()), mouseX, mouseY);
                break;
            }
            guiGraphics.renderComponentTooltip(mc.font, List.of(node.getInstance().getDisplayName((Level)mc.level), node.getInstance().getDescription((Level)mc.level), Component.literal((String)"x: %d, y: %d".formatted(node.getX(), node.getY())), Component.literal((String)"w: %d, h: %d".formatted(node.getWidth(), node.getHeight())), Component.literal((String)"hovered: %s".formatted(node.isHovered())), Component.literal((String)"%d parents".formatted(node.getParents().size())), Component.literal((String)"%d children".formatted(node.getChildren().size()))), mouseX, mouseY);
            break;
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void translate(int dx, int dy) {
        if (this.graph != null && this.graph.nodes() != null) {
            for (ResearchNode researchNode : this.graph.nodes().values()) {
                researchNode.translate(dx, dy);
            }
        }
        for (List list : this.researchLines.values()) {
            for (ResearchLine line : list) {
                line.translate(dx, dy);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.graph == null || this.graph.nodes() == null) {
            return false;
        }
        for (ResearchNode node : this.graph.nodes().values()) {
            if (!node.isHovered()) continue;
            this.setGraph(ResearchGraphCache.computeIfAbsent(node.getInstance().getKey()));
            UniqueArray<ResearchInstance> entries = this.researchScreen.getTechList().entries();
            int index = entries.indexOf(node.getInstance());
            if (index == -1) continue;
            this.researchScreen.getSelectedResearchWidget().setSelectedResearch((ResearchInstance)entries.get(index));
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isHovered()) {
            this.translate((int)dragX, (int)dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void onClose() {
        if (this.graph != null) {
            GraphStateManager.getInstance().saveLastSessionState(this.graph);
        }
    }
}

