/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.widgets;

import com.portingdeadmods.portingdeadlibs.api.client.screens.widgets.AbstractScroller;
import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdClient;
import com.portingdeadmods.researchd.ResearchdConfig;
import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreenWidget;
import com.portingdeadmods.researchd.client.screens.research.widgets.TechListWidget;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.WidgetConstructor;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SelectedResearchWidget
extends ResearchScreenWidget {
    private static final ResourceLocation BACKGROUND_TEXTURE = Researchd.rl("textures/gui/selected_research.png");
    private static final ResourceLocation SMALL_SCROLLER_SPRITE = Researchd.rl("scroller_small");
    public static final int LABEL_PADDING_TOP_1 = 2;
    public static final int LABEL_PADDING_BOTTOM_1 = 4;
    public static final int METHOD_WIDGET_PADDING_BOTTOM = 4;
    public static final int LINE_HEIGHT = 1;
    public static final int LABEL_PADDING_TOP_2 = 2;
    public static final int LABEL_PADDING_BOTTOM_2 = 4;
    public static final int BOTTOM_PADDING = 6;
    public static final int VISIBLE_CONENT_HEIGHT = 47;
    public static final int PADDING_Y = 20;
    public static final int DESCRIPTION_WIDTH = 109;
    public static final int DESCRIPTION_HEIGHT = 48;
    public static final int BACKGROUND_WIDTH = 174;
    public static final int BACKGROUND_HEIGHT = 72;
    public static final int VERTICAL_SCROLLER_WIDTH = 4;
    public static final int VERTICAL_SCROLLER_HEIGHT = 7;
    public static final int HORIZONTAL_SCROLLER_WIDTH = 7;
    public static final int HORIZONTAL_SCROLLER_HEIGHT = 4;
    public static final int HORIZONTAL_SCROLLER_X = 53;
    public static final int HORIZONTAL_SCROLLER_Y = 104;
    public static final int HORIZONTAL_SCROLLER_TRACK_LENGTH = 102;
    public static final int METHOD_WIDGET_PADDING = 3;
    @Nullable
    private ResearchInstance selectedInstance;
    public AbstractWidget methodWidget;
    public AbstractWidget effectWidget;
    public AbstractScroller sideScroller;
    private int scrollOffset;
    private final Font font;
    private final ResearchScreen researchScreen;

    public SelectedResearchWidget(ResearchScreen screen, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.font = Minecraft.getInstance().font;
        this.researchScreen = screen;
        this.sideScroller = new AbstractScroller(this.researchScreen, 53, 104, 7, 4, 102, AbstractScroller.Mode.HORIZONTAL, Researchd.rl("scroller_small_horizontal")){

            public int getContentLength() {
                return 6 + Math.max(SelectedResearchWidget.this.methodWidget.getWidth(), SelectedResearchWidget.this.effectWidget.getWidth());
            }

            public int getVisibleContentLength() {
                return 109;
            }

            public void onScroll() {
                SelectedResearchWidget.this.updateChildWidgetPositions();
            }
        };
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)BACKGROUND_TEXTURE, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height);
        float percentage = (float)this.scrollOffset / ((float)this.getInfoHeight() - 47.0f);
        guiGraphics.blitSprite(SMALL_SCROLLER_SPRITE, this.getX() + this.getWidth() - 9, (int)((float)(this.getY() + 20) + 41.0f * percentage), 4, 7);
        int offsetY = -this.scrollOffset;
        if (this.selectedInstance != null) {
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            int startY = 60;
            guiGraphics.drawScrollingString(font, this.selectedInstance.getDisplayName((Level)mc.level), 11, 169, 49, -1);
            SelectedResearchWidget.renderResearchPanel(guiGraphics, this.selectedInstance, 12, 60, mouseX, mouseY, 2.0f, false);
            int horizontalScrollerArea = this.sideScroller.visible ? 5 : 0;
            guiGraphics.enableScissor(53, startY, 162, startY + 48 - horizontalScrollerArea);
            int yPosMethodLabel = startY + 2;
            guiGraphics.drawString(font, (Component)ResearchdTranslations.component(ResearchdTranslations.Research.SCREEN_LABEL_RESEARCH_METHODS, new Object[0]), 56 - this.sideScroller.getScrollOffset(), offsetY + yPosMethodLabel, -1);
            this.methodWidget.render(guiGraphics, mouseX, mouseY, v);
            Objects.requireNonNull(font);
            int yPosLine = startY + 2 + 9 + 4 + this.methodWidget.getHeight() + 4;
            guiGraphics.fill(53, offsetY + yPosLine, 162, offsetY + yPosLine + 1, -1);
            int yPosEffectsLabel = yPosLine + 1 + 2;
            guiGraphics.drawString(font, (Component)ResearchdTranslations.component(ResearchdTranslations.Research.SCREEN_LABEL_RESEARCH_EFFECTS, new Object[0]), 56 - this.sideScroller.getScrollOffset(), offsetY + yPosEffectsLabel, -1);
            this.effectWidget.render(guiGraphics, mouseX, mouseY, v);
            guiGraphics.disableScissor();
            if (this.sideScroller.visible) {
                guiGraphics.hLine(53, 162, 103, -1);
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY, v);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        AbstractResearchInfoWidget infoWidget;
        AbstractWidget abstractWidget = this.methodWidget;
        if (abstractWidget instanceof AbstractResearchInfoWidget) {
            infoWidget = (AbstractResearchInfoWidget)abstractWidget;
            infoWidget.renderTooltip(guiGraphics, mouseX, mouseY, v);
        }
        if ((abstractWidget = this.effectWidget) instanceof AbstractResearchInfoWidget) {
            infoWidget = (AbstractResearchInfoWidget)abstractWidget;
            infoWidget.renderTooltip(guiGraphics, mouseX, mouseY, v);
        }
    }

    public int getInfoHeight() {
        int methodHeight = this.methodWidget != null ? this.methodWidget.getHeight() : 0;
        int effectHeight = this.effectWidget != null ? this.effectWidget.getHeight() : 0;
        Objects.requireNonNull(this.font);
        int methodSectionHeight = 2 + 9 + 4 + methodHeight + 4;
        Objects.requireNonNull(this.font);
        int effectSectionHeight = 2 + 9 + 4 + effectHeight;
        return methodSectionHeight + 1 + effectSectionHeight + 6;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectedInstance != null) {
            double rawScrollOffset = Math.max((double)this.scrollOffset - scrollY * 5.0, 0.0);
            this.scrollOffset = rawScrollOffset > (double)(this.getInfoHeight() - 47) ? this.getInfoHeight() - 47 : (int)rawScrollOffset;
            this.updateChildWidgetPositions();
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    private void updateChildWidgetPositions() {
        if (this.methodWidget == null || this.effectWidget == null) {
            return;
        }
        float offsetY = this.scrollOffset;
        Objects.requireNonNull(this.font);
        this.methodWidget.setY((int)((float)(62 + 9 + 4) - offsetY));
        this.methodWidget.setX(56 - this.sideScroller.getScrollOffset());
        Objects.requireNonNull(this.font);
        int n = 62 + 9 + 4 + this.methodWidget.getHeight() + 4 + 1 + 2;
        Objects.requireNonNull(this.font);
        this.effectWidget.setY((int)((float)(n + 9 + 4) - offsetY));
        this.effectWidget.setX(56 - this.sideScroller.getScrollOffset());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.effectWidget != null && this.effectWidget.isHovered()) {
            return this.effectWidget.mouseClicked(mouseX, mouseY, button);
        }
        if (this.methodWidget != null && this.methodWidget.isHovered()) {
            return this.methodWidget.mouseClicked(mouseX, mouseY, button);
        }
        int scrollerX = this.getX() + this.getWidth() - 9;
        int trackTop = this.getY() + 20;
        int trackRange = 41;
        if (mouseX >= (double)scrollerX && mouseX < (double)(scrollerX + 4) && mouseY >= (double)trackTop && mouseY <= (double)(trackTop + trackRange + 7) && this.getInfoHeight() > 47) {
            double clamped = Math.clamp(mouseY, (double)trackTop, (double)(trackTop + trackRange)) - (double)trackTop;
            double percentage = clamped / (double)trackRange;
            int scrollableHeight = this.getInfoHeight() - 47;
            this.scrollOffset = (int)((double)scrollableHeight * percentage);
            this.updateChildWidgetPositions();
            return true;
        }
        return false;
    }

    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.mouseClicked(mouseX, mouseY, 0);
    }

    public void setSelectedResearch(@NotNull ResearchInstance instance) {
        if (this.selectedInstance != instance) {
            this.selectedInstance = instance;
            boolean bl = this.researchScreen.getTechListWidget().startResearchButton.active = this.selectedInstance.isResearchable() && !this.researchScreen.getResearchQueueWidget().getQueue().contains(this.selectedInstance.getKey()) && this.researchScreen.getResearchQueueWidget().getQueue().size() < ResearchdConfig.Common.researchQueueLength;
            if (this.selectedInstance.isResearchable() && !this.researchScreen.getResearchQueueWidget().getQueue().isEmpty()) {
                this.researchScreen.getTechListWidget().setResearchButtonMode(TechListWidget.ResearchButtonMode.ENQUEUE);
            } else {
                this.researchScreen.getTechListWidget().setResearchButtonMode(TechListWidget.ResearchButtonMode.START);
            }
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            this.scrollOffset = 0;
            Research research = this.selectedInstance.lookup((Level)mc.level);
            ResearchMethod method = research.researchMethod();
            WidgetConstructor<? extends ResearchMethod> methodWidgetConstructor = ResearchdClient.RESEARCH_METHOD_WIDGETS.get(method.id());
            if (methodWidgetConstructor != null) {
                Objects.requireNonNull(font);
                this.methodWidget = methodWidgetConstructor.createMethod(56, 62 + 9 + 4, method);
            } else {
                MutableComponent message = Component.literal((String)"!!%s does not have info widget!!".formatted(method.id().toString())).withStyle(ChatFormatting.RED);
                Objects.requireNonNull(font);
                this.methodWidget = new MultiLineTextWidget(57, 62 + 9 + 4, (Component)message, font);
                ((MultiLineTextWidget)this.methodWidget).setMaxWidth(108);
            }
            ResearchEffect effect = research.researchEffect();
            WidgetConstructor<? extends ResearchEffect> effectWidgetConstructor = ResearchdClient.RESEARCH_EFFECT_WIDGETS.get(effect.id());
            if (effectWidgetConstructor != null) {
                Objects.requireNonNull(font);
                int n = 62 + 9 + 4 + this.methodWidget.getHeight() + 4 + 1 + 2;
                Objects.requireNonNull(font);
                this.effectWidget = effectWidgetConstructor.createEffect(56, n + 9 + 4, effect);
            } else {
                MutableComponent message = Component.literal((String)"!!%s does not have info widget!!".formatted(effect.id().toString())).withStyle(ChatFormatting.RED);
                Objects.requireNonNull(font);
                this.effectWidget = new MultiLineTextWidget(57, 100 + 9 + 4, (Component)message, font);
                ((MultiLineTextWidget)this.effectWidget).setMaxWidth(108);
            }
            this.sideScroller.visible = this.sideScroller.active = this.methodWidget.getWidth() > 106 || this.effectWidget.getWidth() > 106;
        }
    }

    @Nullable
    public ResearchInstance getSelectedInstance() {
        return this.selectedInstance;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        consumer.accept((AbstractWidget)this.sideScroller);
    }
}

