/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.widgets;

import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.TechList;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.client.cache.ResearchGraphCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreenWidget;
import com.portingdeadmods.researchd.client.screens.research.widgets.ResearchQueueWidget;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.networking.research.ResearchQueueAddPayload;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class TechListWidget
extends ResearchScreenWidget {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final ResourceLocation BACKGROUND_TEXTURE = Researchd.rl("textures/gui/tech_list_screen.png");
    private static final ResourceLocation BOTTOM_TEXTURE = Researchd.rl("textures/gui/tech_list_bottom.png");
    private static final ResourceLocation BACKGROUND_TEXTURE_SEARCH_BAR = Researchd.rl("textures/gui/tech_list_screen_search_bar.png");
    private static final ResourceLocation TECH_LIST_EXPANDABLE = Researchd.rl("textures/gui/research_screen/tech_list_expandable.png");
    private static final int BACKGROUND_WIDTH = 174;
    private static final int BACKGROUND_HEIGHT = 150;
    private static final int BACKGROUND_HEIGHT_SPRITE = 18;
    private static final int BOTTOM_WIDTH = 174;
    private static final int BOTTOM_HEIGHT = 8;
    private static final int PADDING_Y = 21;
    private static final int PADDING_X = 12;
    private final int searchButtonX;
    private final int scrollX;
    private TechList techList;
    private TechList displayTechList;
    private final int cols;
    private int rows;
    private int scrollOffset;
    private ResearchInstance hoveredResearch;
    public final ImageButton searchButton;
    public final Button startResearchButton;
    private final EditBox searchBox;
    private boolean hasSearchBar;
    private final ResearchScreen screen;

    public TechListWidget(ResearchScreen screen, int x, int y, int cols) {
        super(x, y, 174, 150);
        this.cols = cols;
        int padding = 15;
        this.searchButtonX = this.getX() + cols * 20 + padding;
        this.scrollX = this.getX() + cols * 20 + 12 + 4;
        this.searchButton = new ImageButton(this.searchButtonX, y + 4, 14, 14, new WidgetSprites(Researchd.rl("search_button"), Researchd.rl("search_button_highlighted")), this::onSearchButtonClicked);
        Font font = Minecraft.getInstance().font;
        this.startResearchButton = Button.builder((Component)ResearchdTranslations.component(ResearchdTranslations.Research.START_RESEARCH_BUTTON, new Object[0]), this::onStartResearchButtonClicked).bounds(11, y + 4, Math.min(font.width((FormattedText)ResearchdTranslations.component(ResearchdTranslations.Research.ENQUEUE_RESEARCH_BUTTON, new Object[0])), 58), 14).build();
        this.searchBox = new EditBox(font, x + 73 + 2, y + 3 + 4, 78, 14, (Component)Component.empty()){

            public boolean charTyped(char codePoint, int modifiers) {
                String searchValue = this.getValue();
                boolean typed = super.charTyped(codePoint, modifiers);
                String newValue = this.getValue();
                if (!searchValue.equals(newValue)) {
                    TechListWidget.this.refreshSearchResult();
                }
                return typed;
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                String searchValue = this.getValue();
                boolean pressed = super.keyPressed(keyCode, scanCode, modifiers);
                String newValue = this.getValue();
                if (!searchValue.equals(newValue)) {
                    TechListWidget.this.refreshSearchResult();
                }
                return pressed;
            }

            public void setValue(String text) {
                String searchValue = this.getValue();
                super.setValue(text);
                String newValue = this.getValue();
                if (!searchValue.equals(newValue)) {
                    TechListWidget.this.refreshSearchResult();
                }
            }
        };
        this.searchBox.setBordered(false);
        this.searchBox.setVisible(false);
        this.screen = screen;
    }

    public void setResearchButtonMode(ResearchButtonMode mode) {
        this.startResearchButton.setMessage((Component)(mode == ResearchButtonMode.START ? ResearchdTranslations.component(ResearchdTranslations.Research.START_RESEARCH_BUTTON, new Object[0]) : ResearchdTranslations.component(ResearchdTranslations.Research.ENQUEUE_RESEARCH_BUTTON, new Object[0])));
    }

    private void refreshSearchResult() {
        this.displayTechList = this.techList.getListForSearch(this.searchBox.getValue(), (Level)Minecraft.getInstance().level);
        this.scrollOffset = 0;
        this.rows = this.displayTechList.entries().size() / this.cols + (this.displayTechList.entries().size() % this.cols != 0 ? 1 : 0);
    }

    public void setTechList(TechList techList) {
        this.scrollOffset = 0;
        this.techList = techList;
        this.displayTechList = techList;
        this.rows = this.displayTechList.entries().size() / this.cols + (this.displayTechList.entries().size() % this.cols != 0 ? 1 : 0);
    }

    public TechList getDisplayTechList() {
        return this.displayTechList;
    }

    public TechList getTechList() {
        return this.techList;
    }

    public void onSearchButtonClicked(Button button) {
        this.hasSearchBar = !this.hasSearchBar;
        this.searchBox.setVisible(this.hasSearchBar);
        this.displayTechList = this.techList;
    }

    public void onStartResearchButtonClicked(Button button) {
        ResearchQueueWidget queue = this.screen.getResearchQueueWidget();
        ResearchInstance selectedInstance = this.screen.getSelectedResearchWidget().getSelectedInstance();
        if (selectedInstance != null) {
            if (queue.getQueue().add(selectedInstance)) {
                UUID player = Minecraft.getInstance().player.getUUID();
                long gameTime = Minecraft.getInstance().level.getDayTime();
                selectedInstance.setResearchedPlayer(player);
                selectedInstance.setResearchedTime(gameTime);
                ResourceKey<Research> researchKey = selectedInstance.getKey();
                PacketDistributor.sendToServer((CustomPacketPayload)new ResearchQueueAddPayload(researchKey, player, gameTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ClientResearchTeamHelper.getTeam().refreshResearchStatus();
                ClientResearchTeamHelper.refreshResearchScreenData();
            }
            this.startResearchButton.active = false;
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        this.hoveredResearch = null;
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)(this.hasSearchBar ? BACKGROUND_TEXTURE_SEARCH_BAR : BACKGROUND_TEXTURE), (int)this.getX(), (int)(this.getY() + 3), (int)174, (int)18);
        int techListHeight = this.getTechListHeight();
        guiGraphics.blit(TECH_LIST_EXPANDABLE, this.getX(), this.getY() + 18 + 3, 0.0f, 0.0f, 174, techListHeight, 174, 16);
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)BOTTOM_TEXTURE, (int)this.getX(), (int)(this.getY() + 18 + guiGraphics.guiHeight() - this.getY() - 18 - 8), (int)174, (int)8);
        int paddingX = 12;
        int paddingY = 21;
        guiGraphics.enableScissor(12, 130, 152, 130 + techListHeight - 1);
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                int x;
                boolean selected;
                int index = row * this.cols + col;
                if (index >= this.displayTechList.entries().size()) continue;
                ResearchInstance instance = (ResearchInstance)this.displayTechList.entries().get(index);
                int y1 = 21 + this.getY() + row * 24 - this.scrollOffset;
                boolean bl = selected = instance == this.screen.getSelectedResearchWidget().getSelectedInstance();
                if (selected) {
                    y1 += 2;
                }
                if (TechListWidget.isHovering(guiGraphics, x = paddingX + this.getX() + col * 20, y1, mouseX, mouseY)) {
                    this.hoveredResearch = instance;
                }
                if (index >= this.displayTechList.entries().size() - this.cols) {
                    if (selected) {
                        TechListWidget.renderSmallResearchPanel(guiGraphics, instance, x, y1, mouseX, mouseY);
                        continue;
                    }
                    TechListWidget.renderResearchPanel(guiGraphics, instance, x, y1, mouseX, mouseY);
                    continue;
                }
                TechListWidget.renderTallResearchPanel(guiGraphics, instance, x, y1, mouseX, mouseY);
            }
        }
        guiGraphics.disableScissor();
        float percentage = (float)this.scrollOffset / (float)(this.getContentHeight() - techListHeight);
        guiGraphics.blitSprite(SCROLLER_SPRITE, this.scrollX, (int)((float)(this.getY() + 21) + percentage * (float)(techListHeight - 15 - 1)), 12, 15);
    }

    private int getTechListHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.getY() - 18 - 8;
    }

    public int getContentHeight() {
        return this.rows * 24;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered(mouseX, mouseY, 12, 130, 156, this.getTechListHeight() - 1) && this.getContentHeight() > this.getTechListHeight()) {
            double rawScrollOffset = (int)Math.max((double)this.scrollOffset - scrollY * 7.0, 0.0);
            this.scrollOffset = rawScrollOffset > (double)(this.getContentHeight() - this.getTechListHeight() + 1) ? this.getContentHeight() - this.getTechListHeight() + 1 : (int)rawScrollOffset;
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hoveredResearch != null) {
            this.screen.getResearchGraphWidget().setGraph(ResearchGraphCache.computeIfAbsent(this.hoveredResearch.getKey()));
            this.screen.getSelectedResearchWidget().setSelectedResearch(this.hoveredResearch);
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (mouseX >= (double)this.scrollX && mouseX < (double)(this.scrollX + 12) && mouseY >= (double)(this.getY() + 21) && mouseY < (double)(this.getY() + 21 + this.getTechListHeight() - 1) && this.getContentHeight() > this.getTechListHeight()) {
            int scrollableHeight = this.getContentHeight() - this.getTechListHeight();
            int minY = this.getY() + 21 + 7;
            int maxY = this.getY() + 21 + this.getTechListHeight() - 1 - 8;
            double scrolledPercentage = (Math.clamp(mouseY, (double)minY, (double)maxY) - (double)minY) / (double)(maxY - minY);
            this.scrollOffset = (int)((double)scrollableHeight * scrolledPercentage);
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (mouseX >= (double)this.scrollX && mouseX < (double)(this.scrollX + 12) && mouseY >= (double)(this.getY() + 21) && mouseY < (double)(this.getY() + 21 + this.getTechListHeight() - 1) && this.getContentHeight() > this.getTechListHeight()) {
            this.mouseClicked(mouseX, mouseY, 0);
        }
    }

    private boolean isHovered(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        consumer.accept((AbstractWidget)this.searchButton);
        consumer.accept((AbstractWidget)this.startResearchButton);
        consumer.accept((AbstractWidget)this.searchBox);
    }

    public static enum ResearchButtonMode {
        START,
        ENQUEUE;

    }
}

