/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.team;

import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.client.screens.team.BaseTeamScreen;
import com.portingdeadmods.researchd.client.screens.team.ResearchTeamSettingsScreen;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementDraggableWidget;
import com.portingdeadmods.researchd.client.screens.team.widgets.RecentResearchesList;
import com.portingdeadmods.researchd.client.screens.team.widgets.TeamMembersList;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;

public class ResearchTeamScreen
extends BaseTeamScreen {
    public static final ResourceLocation SCREEN_TEXTURE = Researchd.rl("textures/gui/team_screen.png");
    public static final WidgetSprites TEAM_MEMBER_BUTTON_SPRITES = new WidgetSprites(Researchd.rl("team_member"), Researchd.rl("team_member_focused"));
    public static final WidgetSprites SETTINGS_BUTTON_SPRITES = new WidgetSprites(Researchd.rl("settings_button"), Researchd.rl("settings_button_disabled"), Researchd.rl("settings_button_focused"));
    public static final WidgetSprites INVITE_BUTTON_SPRITES = new WidgetSprites(Researchd.rl("invite_button"), Researchd.rl("invite_button_disabled"), Researchd.rl("invite_button_focused"));
    public static final WidgetSprites RECENT_RESEARCH_SPRITES = new WidgetSprites(Researchd.rl("recent_research"), Researchd.rl("recent_research_focused"));
    private LocalPlayer player;
    private LinearLayout layout;
    private EditBox teamNameEdit;
    private ImageButton inviteButton;
    private ImageButton settingsButton;
    private PlayerManagementDraggableWidget inviteWidget;
    private TeamMembersList teamMembersList;

    public PlayerManagementDraggableWidget getInviteWidget() {
        return this.inviteWidget;
    }

    public TeamMembersList getTeamMembersList() {
        return this.teamMembersList;
    }

    public ResearchTeamScreen() {
        super((Component)ResearchdTranslations.component(ResearchdTranslations.Team.SCREEN_TITLE, new Object[0]), 480, 264, 352, 200);
    }

    @Override
    protected void init() {
        super.init();
        Minecraft mc = Minecraft.getInstance();
        this.player = mc.player;
        ResearchTeam researchTeam = ResearchTeamHelper.getTeamByMember((Player)Objects.requireNonNull(this.player));
        String name = researchTeam.getName();
        List<ResearchInstance> recentResearches = ResearchHelperCommon.getRecentResearches(researchTeam);
        this.layout = LinearLayout.vertical().spacing(5);
        LinearLayout headerLayout = (LinearLayout)this.layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(4));
        this.teamNameEdit = (EditBox)headerLayout.addChild((LayoutElement)new EditBox(this, this.font, 208, 16, (Component)Component.empty()){

            public void setFocused(boolean focused) {
                super.setFocused(focused);
                if (!focused) {
                    ClientResearchTeamHelper.setTeamNameSynced(this.getValue());
                }
            }
        });
        this.teamNameEdit.setValue(name);
        this.teamNameEdit.setTextColor(FastColor.ARGB32.color((int)255, (int)140, (int)140, (int)140));
        this.teamNameEdit.setMaxLength(32);
        this.teamNameEdit.setTextShadow(false);
        this.teamNameEdit.setBordered(false);
        headerLayout.addChild((LayoutElement)new SpacerElement(77, 0));
        this.inviteButton = new ImageButton(14, 14, INVITE_BUTTON_SPRITES, btn -> this.inviteWidget.setVisible(!this.inviteWidget.visible), (Component)ResearchdTranslations.component(ResearchdTranslations.Team.BUTTON_INVITE, new Object[0]));
        headerLayout.addChild((LayoutElement)this.inviteButton);
        this.settingsButton = new ImageButton(14, 14, SETTINGS_BUTTON_SPRITES, btn -> {
            ResearchTeamSettingsScreen screen = new ResearchTeamSettingsScreen();
            screen.setTempTeamName(this.teamNameEdit.getValue());
            Minecraft.getInstance().setScreen((Screen)screen);
        }, (Component)ResearchdTranslations.component(ResearchdTranslations.Team.BUTTON_TEAM_SETTINGS, new Object[0]));
        headerLayout.addChild((LayoutElement)this.settingsButton);
        LinearLayout linearLayout = (LinearLayout)this.layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(-1));
        LinearLayout teamMembersLayout = (LinearLayout)linearLayout.addChild((LayoutElement)LinearLayout.vertical());
        teamMembersLayout.addChild((LayoutElement)new StringWidget((Component)ResearchdTranslations.component(ResearchdTranslations.Team.TITLE_MEMBERS, new Object[0]), this.font));
        teamMembersLayout.addChild((LayoutElement)new SpacerElement(-1, 1));
        linearLayout.spacing(11);
        this.teamMembersList = (TeamMembersList)teamMembersLayout.addChild((LayoutElement)new TeamMembersList(94, 142, 94, 22, ClientResearchTeamHelper.getTeamMembers(), false));
        linearLayout.spacing(11);
        LinearLayout recentResearchesLayout = (LinearLayout)linearLayout.addChild((LayoutElement)LinearLayout.vertical());
        recentResearchesLayout.addChild((LayoutElement)new StringWidget((Component)ResearchdTranslations.component(ResearchdTranslations.Team.TITLE_RECENTLY_RESEARCHED, new Object[0]), this.font));
        recentResearchesLayout.spacing(1);
        recentResearchesLayout.addChild((LayoutElement)new RecentResearchesList(230, 142, 221, 32, (Collection<ResearchInstance>)recentResearches, true));
        this.layout.arrangeElements();
        this.layout.setX(this.leftPos + 10);
        this.layout.setY(this.topPos + 11);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.teamMembersList.setX(this.teamMembersList.getX() - 1);
        this.inviteWidget = new PlayerManagementDraggableWidget(this.leftPos, this.topPos, ClientResearchTeamHelper.getPlayersNotInTeam(), new PlayerManagementDraggableWidget.PlayerManagementButtons(false, false, false, false, true), (Component)Component.empty());
        this.inviteWidget.setVisible(false);
        this.inviteWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableOnly((Renderable)x$0);
        });
        this.inviteButton.active = !ClientResearchTeamHelper.getPlayersNotInTeam().isEmpty();
        this.inviteButton.active = this.inviteButton.active && ClientResearchTeamHelper.getPlayerPermissionLevel((Player)this.player) >= 1;
    }

    public void onClose() {
        super.onClose();
        ClientResearchTeamHelper.setTeamNameSynced(this.teamNameEdit.getValue());
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.inviteWidget.isLazyHovered()) {
            return this.inviteWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.inviteWidget.isHovered()) {
            return this.inviteWidget.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(SCREEN_TEXTURE, this.leftPos, this.topPos, this.textureWidth, this.textureHeight, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.inviteButton.active = !ClientResearchTeamHelper.getPlayersNotInTeam().isEmpty();
        this.inviteButton.active = this.inviteButton.active && ClientResearchTeamHelper.getPlayerPermissionLevel((Player)this.player) >= 1;
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

