/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.team;

import com.portingdeadmods.portingdeadlibs.utils.PlayerUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.api.team.ResearchTeamRole;
import com.portingdeadmods.researchd.client.screens.team.BaseTeamScreen;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementDraggableWidget;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.networking.team.LeaveTeamPayload;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class ResearchTeamSettingsScreen
extends BaseTeamScreen {
    public static final ResourceLocation SCREEN_TEXTURE = Researchd.rl("textures/gui/team_settings_screen.png");
    private LinearLayout layout;
    private final Screen prevScreen;
    private String tempTeamName;
    private StringWidget titleWidget;
    private EditBox teamNameEdit;
    private Button manageMembersButton;
    private Button transferOwnershipButton;
    private Button leaveButton;
    private PlayerManagementDraggableWidget playerManagementWindow;
    private PlayerManagementDraggableWidget transferOwnershipWindow;

    public PlayerManagementDraggableWidget getPlayerManagementWindow() {
        return this.playerManagementWindow;
    }

    public PlayerManagementDraggableWidget getTransferOwnershipWindow() {
        return this.transferOwnershipWindow;
    }

    public ResearchTeamSettingsScreen() {
        super((Component)ResearchdTranslations.component(ResearchdTranslations.Team.SETTINGS_SCREEN_TITLE, new Object[0]), 480, 264, 128, 195);
        this.prevScreen = Minecraft.getInstance().screen;
    }

    @Override
    protected void init() {
        super.init();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ResearchTeam researchTeam = ResearchTeamHelper.getTeamByMember((Player)Objects.requireNonNull(player));
        this.layout = LinearLayout.vertical().spacing(8);
        this.layout.setPosition(this.leftPos + 8, this.topPos + 6);
        this.titleWidget = new StringWidget(this.title, this.font);
        this.layout.addChild((LayoutElement)this.titleWidget);
        this.teamNameEdit = (EditBox)this.layout.addChild((LayoutElement)new EditBox(this.font, 112, 16, (Component)Component.empty()));
        if (this.tempTeamName == null) {
            this.teamNameEdit.setValue(researchTeam.getName());
        } else {
            this.teamNameEdit.setValue(this.tempTeamName);
            this.tempTeamName = null;
        }
        this.manageMembersButton = Button.builder((Component)ResearchdTranslations.component(ResearchdTranslations.Team.BUTTON_MANAGE_MEMBERS, new Object[0]), btn -> this.playerManagementWindow.setVisible(!this.playerManagementWindow.visible)).size(112, 16).build();
        this.transferOwnershipButton = Button.builder((Component)ResearchdTranslations.component(ResearchdTranslations.Team.BUTTON_TRANSFER_OWNERSHIP, new Object[0]), btn -> this.transferOwnershipWindow.setVisible(!this.transferOwnershipWindow.visible)).size(112, 16).build();
        this.leaveButton = Button.builder((Component)ResearchdTranslations.component(ResearchdTranslations.Team.BUTTON_LEAVE_TEAM, new Object[0]), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new LeaveTeamPayload(PlayerUtils.EmptyUUID), (CustomPacketPayload[])new CustomPacketPayload[0])).size(112, 16).build();
        if (ClientResearchTeamHelper.getPlayerRole(Minecraft.getInstance().player.getUUID()) == ResearchTeamRole.OWNER) {
            this.layout.addChild((LayoutElement)this.manageMembersButton);
            this.layout.addChild((LayoutElement)this.transferOwnershipButton);
        }
        this.layout.addChild((LayoutElement)this.leaveButton);
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.playerManagementWindow = new PlayerManagementDraggableWidget(this.leftPos, this.topPos, ClientResearchTeamHelper.getTeamMembers(), new PlayerManagementDraggableWidget.PlayerManagementButtons(true, true, true, false, false), (Component)Component.empty());
        this.playerManagementWindow.setVisible(false);
        this.playerManagementWindow.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableOnly((Renderable)x$0);
        });
        this.transferOwnershipWindow = new PlayerManagementDraggableWidget(this.leftPos + this.width / 2, this.topPos + this.height / 2, ClientResearchTeamHelper.getTeamMembers(), new PlayerManagementDraggableWidget.PlayerManagementButtons(false, false, false, true, false), (Component)Component.empty());
        this.transferOwnershipWindow.setVisible(false);
        this.transferOwnershipWindow.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableOnly((Renderable)x$0);
        });
    }

    public void setTempTeamName(String tempTeamName) {
        this.tempTeamName = tempTeamName;
    }

    public void onClose() {
        super.onClose();
        if (this.prevScreen != null) {
            Minecraft.getInstance().setScreen(this.prevScreen);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.playerManagementWindow.isLazyHovered()) {
            return this.playerManagementWindow.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.transferOwnershipWindow.isLazyHovered()) {
            return this.transferOwnershipWindow.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.playerManagementWindow.isHovered()) {
            return this.playerManagementWindow.mouseClicked(mouseX, mouseY, button);
        }
        if (this.transferOwnershipWindow.isHovered()) {
            return this.transferOwnershipWindow.mouseClicked(mouseX, mouseY, button);
        }
        if (this.transferOwnershipWindow.popupWidget.isHovered()) {
            return this.transferOwnershipWindow.popupWidget.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.playerManagementWindow.isLazyHovered()) {
            return this.playerManagementWindow.mouseReleased(mouseX, mouseY, button);
        }
        if (this.transferOwnershipWindow.isLazyHovered()) {
            return this.transferOwnershipWindow.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.manageMembersButton.active = ClientResearchTeamHelper.getRole().getPermissionLevel() > 0;
        this.transferOwnershipButton.active = ClientResearchTeamHelper.getRole() == ResearchTeamRole.OWNER;
        this.teamNameEdit.setEditable(ClientResearchTeamHelper.getRole() == ResearchTeamRole.OWNER);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(SCREEN_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

