/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.team.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.portingdeadlibs.cache.AllPlayersCache;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.widgets.ContainerWidget;
import com.portingdeadmods.researchd.api.team.ResearchTeamRole;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.client.screens.team.widgets.DraggableWidgetImageButton;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementDraggableWidget;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PlayerManagementList
extends ContainerWidget<Entry> {
    public static final ResourceLocation PLAYER_ENTRY_TEXTURE = Researchd.rl("player");
    private final Map<Entry, List<DraggableWidgetImageButton>> buttonWidgets = new HashMap<Entry, List<DraggableWidgetImageButton>>();
    private final AbstractWidget parent;

    private boolean _should_add_button(Entry item, PlayerManagementDraggableWidget.PlayerManagementButtonType type) {
        ResearchTeamRole clientRole = ClientResearchTeamHelper.getRole();
        ResearchTeamRole targetRole = item.teamMember.role();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlayerManagementDraggableWidget.PlayerManagementButtonType.PROMOTE -> {
                if (clientRole == ResearchTeamRole.OWNER && targetRole == ResearchTeamRole.MEMBER) {
                    yield true;
                }
                yield false;
            }
            case PlayerManagementDraggableWidget.PlayerManagementButtonType.DEMOTE -> {
                if (clientRole == ResearchTeamRole.OWNER && targetRole == ResearchTeamRole.MODERATOR) {
                    yield true;
                }
                yield false;
            }
            case PlayerManagementDraggableWidget.PlayerManagementButtonType.REMOVE -> {
                if (clientRole == ResearchTeamRole.OWNER && targetRole != ResearchTeamRole.OWNER || clientRole == ResearchTeamRole.MODERATOR && targetRole == ResearchTeamRole.MEMBER) {
                    yield true;
                }
                yield false;
            }
            case PlayerManagementDraggableWidget.PlayerManagementButtonType.INVITE_PLAYER -> {
                if (clientRole == ResearchTeamRole.OWNER || clientRole == ResearchTeamRole.MODERATOR) {
                    yield true;
                }
                yield false;
            }
            case PlayerManagementDraggableWidget.PlayerManagementButtonType.TRANSFER_OWNERSHIP -> clientRole == ResearchTeamRole.OWNER && targetRole != ResearchTeamRole.OWNER;
        };
    }

    public PlayerManagementList(int width, int height, int itemWidth, int itemHeight, Collection<Entry> items, boolean renderScroller, AbstractWidget parent) {
        super(width, height, itemWidth, itemHeight, items, renderScroller);
        this.parent = parent;
        for (Entry item : items) {
            this.buttonWidgets.put(item, new ArrayList());
            if (item.teamMember.role() == ResearchTeamRole.OWNER) continue;
            for (Map.Entry<PlayerManagementDraggableWidget.PlayerManagementButtonType, WidgetSprites> entry : item.buttonSettings().getSprites().entrySet()) {
                if (!this._should_add_button(item, entry.getKey())) continue;
                this.buttonWidgets.get(item).add(new DraggableWidgetImageButton(0, 0, 12, 12, entry.getValue(), btn -> {
                    PlayerManagementDraggableWidget widget;
                    AbstractWidget patt0$temp;
                    switch ((PlayerManagementDraggableWidget.PlayerManagementButtonType)((Object)((Object)entry.getKey()))) {
                        case PROMOTE: {
                            ClientResearchTeamHelper.promoteTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case DEMOTE: {
                            ClientResearchTeamHelper.demoteTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case REMOVE: {
                            ClientResearchTeamHelper.removeTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case INVITE_PLAYER: {
                            ClientResearchTeamHelper.sendTeamInviteSynced(item.teamMember());
                            break;
                        }
                        case TRANSFER_OWNERSHIP: {
                            patt0$temp = this.parent;
                            if (!(patt0$temp instanceof PlayerManagementDraggableWidget)) break;
                            widget = (PlayerManagementDraggableWidget)patt0$temp;
                            widget.openPopupWidget(item.teamMember());
                        }
                    }
                    patt0$temp = this.parent;
                    if (patt0$temp instanceof PlayerManagementDraggableWidget) {
                        widget = (PlayerManagementDraggableWidget)patt0$temp;
                        widget.refreshFunction.accept(item, (PlayerManagementDraggableWidget.PlayerManagementButtonType)((Object)((Object)entry.getKey())));
                    }
                }));
            }
        }
        this.resort();
    }

    @Override
    public void clickedItem(Entry item, int index, int left, int top, int mouseX, int mouseY) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int index = 0;
        for (Entry item : this.getItems()) {
            List<DraggableWidgetImageButton> buttons;
            int top = this.getY() + 1 + index * this.getItemHeight() - this.scrollOffset;
            int left = this.getX() + 1;
            if (top >= this.getY() + 1 && top < this.getY() + this.getHeight() && (buttons = this.buttonWidgets.get(item)) != null) {
                int i = 0;
                for (DraggableWidgetImageButton widget : buttons) {
                    widget.setPosition(left + 84 - (i + 1) * 14, top + 2);
                    if (widget.mouseClicked(mouseX, mouseY, button)) {
                        return true;
                    }
                    ++i;
                }
            }
            ++index;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void renderItem(GuiGraphics guiGraphics, Entry item, int index, int left, int top, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 501.0f);
        guiGraphics.blitSprite(PLAYER_ENTRY_TEXTURE, left, top, 84, 16);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 502.0f);
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)AllPlayersCache.getSkin((UUID)item.teamMember.player()), (int)(left + 3), (int)(top + 3), (int)10);
        guiGraphics.drawScrollingString(Minecraft.getInstance().font, (Component)Component.literal((String)AllPlayersCache.getName((UUID)item.teamMember.player())).withStyle(ChatFormatting.WHITE), left + 3 + 12, left + 84 - this.buttonWidgets.get(item).size() * 14 - 2, top + 4, -1);
        poseStack.popPose();
        int i = 0;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 503.0f);
        for (DraggableWidgetImageButton widget : this.buttonWidgets.get(item)) {
            widget.setPosition(left + 84 - (i + 1) * 14, top + 2);
            widget.render(guiGraphics, mouseX, mouseY, -1.0f);
            ++i;
        }
        poseStack.popPose();
    }

    public void resort() {
        this.sortEntriesBy(Comparator.comparing(entry -> ClientResearchTeamHelper.getPlayerRole(entry.teamMember().player()).getPermissionLevel(), Comparator.reverseOrder()));
    }

    public void refreshEntries(Collection<Entry> newEntries) {
        this.getItems().clear();
        this.getItems().addAll(newEntries);
        for (Entry item : newEntries) {
            this.buttonWidgets.put(item, new ArrayList());
            if (item.teamMember.role() == ResearchTeamRole.OWNER) continue;
            for (Map.Entry<PlayerManagementDraggableWidget.PlayerManagementButtonType, WidgetSprites> entry : item.buttonSettings().getSprites().entrySet()) {
                if (!this._should_add_button(item, entry.getKey())) continue;
                this.buttonWidgets.get(item).add(new DraggableWidgetImageButton(0, 0, 12, 12, entry.getValue(), btn -> {
                    PlayerManagementDraggableWidget widget;
                    AbstractWidget patt0$temp;
                    switch ((PlayerManagementDraggableWidget.PlayerManagementButtonType)((Object)((Object)entry.getKey()))) {
                        case PROMOTE: {
                            ClientResearchTeamHelper.promoteTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case DEMOTE: {
                            ClientResearchTeamHelper.demoteTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case REMOVE: {
                            ClientResearchTeamHelper.removeTeamMemberSynced(item.teamMember());
                            break;
                        }
                        case INVITE_PLAYER: {
                            ClientResearchTeamHelper.sendTeamInviteSynced(item.teamMember());
                            break;
                        }
                        case TRANSFER_OWNERSHIP: {
                            patt0$temp = this.parent;
                            if (!(patt0$temp instanceof PlayerManagementDraggableWidget)) break;
                            widget = (PlayerManagementDraggableWidget)patt0$temp;
                            widget.openPopupWidget(item.teamMember());
                        }
                    }
                    patt0$temp = this.parent;
                    if (patt0$temp instanceof PlayerManagementDraggableWidget) {
                        widget = (PlayerManagementDraggableWidget)patt0$temp;
                        widget.refreshFunction.accept(item, (PlayerManagementDraggableWidget.PlayerManagementButtonType)((Object)((Object)entry.getKey())));
                    }
                }));
            }
        }
        this.resort();
    }

    public record Entry(TeamMember teamMember, PlayerManagementDraggableWidget.PlayerManagementButtons buttonSettings) {
    }
}

