/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat.kubejs.builders;

import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.impl.research.ItemResearchIcon;
import com.portingdeadmods.researchd.impl.research.SimpleResearch;
import com.portingdeadmods.researchd.impl.research.effect.EmptyResearchEffect;
import com.portingdeadmods.researchd.impl.research.method.ConsumeItemResearchMethod;
import dev.latvian.mods.kubejs.script.SourceLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ResearchBuilder {
    public final ResourceLocation id;
    public SourceLine sourceLine;
    private ItemResearchIcon icon = ItemResearchIcon.EMPTY;
    private ResearchMethod researchMethod;
    private ResearchEffect researchEffect = EmptyResearchEffect.INSTANCE;
    private final List<ResourceKey<Research>> parents = new ArrayList<ResourceKey<Research>>();
    private boolean requiresParent = false;
    private Component literalName = null;
    private Component literalDescription = null;

    public ResearchBuilder(ResourceLocation id) {
        this.id = id;
        this.sourceLine = SourceLine.UNKNOWN;
        this.researchMethod = new ConsumeItemResearchMethod(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOK}), 1);
    }

    public ResearchBuilder icon(String ... itemId) {
        return this.iconStacks((ItemStack[])Stream.of(itemId).map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).map(Item::getDefaultInstance).toArray(ItemStack[]::new));
    }

    public ResearchBuilder iconStacks(ItemStack ... stacks) {
        this.icon = new ItemResearchIcon(Arrays.asList(stacks));
        return this;
    }

    public ResearchBuilder method(ResearchMethod method) {
        this.researchMethod = method;
        return this;
    }

    public ResearchBuilder effect(ResearchEffect effect) {
        this.researchEffect = effect;
        return this;
    }

    public ResearchBuilder parent(String parent) {
        ResourceLocation location = ResourceLocation.parse((String)parent);
        this.parents.add((ResourceKey<Research>)ResourceKey.create(ResearchdRegistries.RESEARCH_KEY, (ResourceLocation)location));
        return this;
    }

    public ResearchBuilder parents(String ... parents) {
        for (String parent : parents) {
            this.parent(parent);
        }
        return this;
    }

    public ResearchBuilder requiresParents(boolean requiresParent) {
        this.requiresParent = requiresParent;
        return this;
    }

    public ResearchBuilder literalName(String name) {
        this.literalName = Component.literal((String)name);
        return this;
    }

    public ResearchBuilder literalDescription(String description) {
        this.literalDescription = Component.literal((String)description);
        return this;
    }

    public ResearchBuilder translatableName(String key) {
        this.literalName = Component.translatable((String)key);
        return this;
    }

    public ResearchBuilder translatableDescription(String key) {
        this.literalDescription = Component.translatable((String)key);
        return this;
    }

    public Research createObject() {
        if (this.parents.isEmpty() && this.requiresParent) {
            throw new IllegalStateException("Research '" + String.valueOf(this.id) + "' requires a parent but has no parents defined. Set requiresParent to false or add parents.");
        }
        SimpleResearch.Builder builder = SimpleResearch.builder().icon(this.icon).method(this.researchMethod).effect(this.researchEffect).parents(this.parents).requiresParent(this.requiresParent);
        if (this.literalName != null) {
            builder.literalName(this.literalName);
        }
        if (this.literalDescription != null) {
            builder.literalDescription(this.literalDescription);
        }
        return builder.build();
    }
}

