/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat.kubejs.event;

import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.compat.kubejs.builders.ResearchPackBuilder;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.SourceLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RegisterResearchPacksKubeEvent
implements KubeEvent {
    private final Map<ResourceLocation, ResearchPackImpl> researchPacks = new HashMap<ResourceLocation, ResearchPackImpl>();
    private final List<ResearchPackBuilder> builders = new ArrayList<ResearchPackBuilder>();

    public ResearchPackBuilder create(String id) {
        ResourceLocation location = ResourceLocation.parse((String)id);
        ResearchPackBuilder builder = new ResearchPackBuilder(location);
        builder.sourceLine = SourceLine.UNKNOWN;
        this.builders.add(builder);
        return builder;
    }

    public ItemStack createItem(String packId) {
        ResourceLocation location = ResourceLocation.parse((String)packId);
        ResourceKey key = ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)location);
        return ResearchPackImpl.asStack((ResourceKey<ResearchPack>)key);
    }

    public Map<ResourceLocation, ResearchPackImpl> getResearchPacks() {
        for (ResearchPackBuilder builder : this.builders) {
            try {
                ResearchPackImpl pack = builder.createObject();
                this.researchPacks.put(builder.id, pack);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create research pack " + String.valueOf(builder.id), e);
            }
        }
        return this.researchPacks;
    }
}

