/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat.kubejs.example;

import com.portingdeadmods.portingdeadlibs.utils.Result;
import com.portingdeadmods.researchd.Researchd;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class KubeJSExample {
    public static final String CODE = "ResearchdEvents.registerResearchPacks(event => {\n    event.create('rd_examples_js:test_pack')\n        .translatableName(\"research_pack.rd_example_js.test_pack\")\n        .literalDescription(\"Testing...\")\n        .color(120, 150, 90)\n        .sortingValue(0);\n});\n\nResearchdEvents.registerResearches(event => {\n    event.create('rd_example_js:wood')\n        .icon('minecraft:oak_log')\n        .literalName(\"Oak log\")\n        .method(ResearchMethodHelper.and(\n            ResearchMethodHelper.consumeItem('minecraft:wheat_seeds', 1),\n            ResearchMethodHelper.consumeItem('minecraft:dirt', 8)\n        ))\n        .effect(ResearchEffectHelper.unlockRecipe('minecraft:oak_planks'));\n\n    event.create('rd_example_js:iron')\n        .icon('minecraft:iron_ingot')\n        .translatableDescription(\"research.rd_example_js.iron_desc\")\n        .parents('rd_example_js:wood')\n        .method(ResearchMethodHelper.or(\n            ResearchMethodHelper.consumeItem('minecraft:furnace', 1),\n            ResearchMethodHelper.consumeItem('minecraft:cobblestone', 8)\n        ))\n        .effect(ResearchEffectHelper.unlockRecipe('minecraft:iron_pickaxe'));\n\n    event.create('rd_example_js:nether_dim')\n        .icon('minecraft:netherrack')\n        .parents('rd_example_js:iron')\n        .method(ResearchMethodHelper.consumePack('rd_example_js:test_pack', 50, 20))\n        .effect(ResearchEffectHelper.and(\n            ResearchEffectHelper.unlockRecipe('minecraft:gold_block'),\n            ResearchEffectHelper.unlockRecipe('minecraft:netherite_ingot')\n        ));\n});\n\n";

    public static Result<Path, Exception> createExample() {
        Path directory = KubeJSPaths.SERVER_SCRIPTS;
        try {
            if (Files.exists(directory, new LinkOption[0])) {
                Path exampleFile = directory.resolve("research_examples.js");
                if (Files.notExists(exampleFile, new LinkOption[0])) {
                    Files.writeString(exampleFile, (CharSequence)CODE, new OpenOption[0]);
                    return Result.ok((Object)exampleFile);
                }
                return Result.err((Exception)new Exception("File already exists"));
            }
            return Result.err((Exception)new Exception("KubeJS server_scripts directory doesn't exist"));
        }
        catch (IOException e) {
            Researchd.LOGGER.error("Failed to create KubeJS Examples", (Throwable)e);
            return Result.err((Exception)new Exception("File creation failed"));
        }
    }
}

