/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.blockentities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockControllerBE;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.PDLAbstractContainerMenu;
import com.portingdeadmods.portingdeadlibs.utils.LazyFinal;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.content.items.ResearchPackItem;
import com.portingdeadmods.researchd.content.menus.ResearchLabMenu;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.data.components.ResearchPackComponent;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.registries.ResearchdBlockEntityTypes;
import com.portingdeadmods.researchd.registries.ResearchdDataComponents;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ResearchLabControllerBE
extends GhostMultiblockControllerBE
implements MenuProvider {
    public LazyFinal<List<BlockPos>> partPos;
    public Map<ResourceKey<ResearchPack>, Float> researchPackUsage = new HashMap<ResourceKey<ResearchPack>, Float>();
    public int currentResearchDuration = -1;
    public List<ResourceKey<ResearchPack>> researchPacks;

    public ResearchLabControllerBE(BlockPos pos, BlockState blockState) {
        super(ResearchdBlockEntityTypes.RESEARCH_LAB_CONTROLLER.get(), pos, blockState);
        this.addItemHandler(HandlerUtils::newItemStackHandler, builder -> (ContainerBlockEntity.ItemHandlerBuilder)((ContainerBlockEntity.ItemHandlerBuilder)builder.onChange(slot -> this.updateData())).validator(this::isItemValid));
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.researchPacks = ResearchHelperCommon.getResearchPackKeys(level);
        this.researchPacks.forEach(key -> this.researchPackUsage.computeIfAbsent((ResourceKey<ResearchPack>)key, $ -> Float.valueOf(0.0f)));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getItemHandler().getSlots(); ++i) {
            stacks.add(this.getItemHandler().getStackInSlot(i));
        }
        ItemStackHandler itemHandler = (ItemStackHandler)this.getItemHandler();
        itemHandler.setSize(this.researchPacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            itemHandler.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    private boolean isItemValid(int slot, ItemStack stack) {
        if (stack.has(ResearchdDataComponents.RESEARCH_PACK.get()) && this.researchPacks.size() > slot) {
            ResourceKey<ResearchPack> packKey = this.researchPacks.get(slot);
            Optional<ResourceKey<ResearchPack>> itemPackKey = ((ResearchPackComponent)stack.get(ResearchdDataComponents.RESEARCH_PACK.get())).researchPackKey();
            if (itemPackKey.isPresent()) {
                return packKey.compareTo(itemPackKey.get()) == 0;
            }
        }
        return false;
    }

    public boolean containsNecessaryPacks(List<ResourceKey<ResearchPack>> packs) {
        ArrayList<ResourceKey<ResearchPack>> packsCopy = new ArrayList<ResourceKey<ResearchPack>>(packs);
        IItemHandler handler = this.getItemHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ResearchPackComponent component;
            ResourceKey<ResearchPack> key;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof ResearchPackItem) || !packsCopy.contains(key = (component = (ResearchPackComponent)stack.get(ResearchdDataComponents.RESEARCH_PACK)).researchPackKey().get()) && !(this.researchPackUsage.getOrDefault(key, Float.valueOf(0.0f)).floatValue() > 0.0f)) continue;
            packsCopy.remove(key);
        }
        return packsCopy.isEmpty();
    }

    public void decreaseNecessaryPackCount(List<ResourceKey<ResearchPack>> packs) {
        IItemHandler handler = this.getItemHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ResearchPackComponent component;
            ResourceKey<ResearchPack> key;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof ResearchPackItem) || !packs.contains(key = (component = (ResearchPackComponent)stack.get(ResearchdDataComponents.RESEARCH_PACK)).researchPackKey().get()) || this.researchPackUsage.getOrDefault(key, Float.valueOf(0.0f)).floatValue() != 0.0f) continue;
            stack.shrink(1);
            this.researchPackUsage.put(key, Float.valueOf(this.researchPackUsage.getOrDefault(key, Float.valueOf(0.0f)).floatValue() + 1.0f));
        }
    }

    public void tick() {
        super.tick();
        ResearchTeam team = ResearchTeamHelper.getTeamByMember(this.getLevel(), (UUID)this.getData(ResearchdAttachments.PLACED_BY_UUID));
        ResourceKey<Research> current = team.getCurrentResearch();
        if (current == null) {
            return;
        }
        ResearchProgress progress = team.getResearchProgresses().get(current);
        if (progress == null) {
            return;
        }
        progress.checkProgress(current, this.level, new ResearchMethod.SimpleMethodContext(team, this));
    }

    protected void saveData(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag researchPackUsageTag = new CompoundTag();
        for (Map.Entry<ResourceKey<ResearchPack>, Float> entry : this.researchPackUsage.entrySet()) {
            researchPackUsageTag.putFloat(entry.getKey().location().toString(), entry.getValue().floatValue());
        }
        tag.put("research_pack_usage", (Tag)researchPackUsageTag);
        super.saveData(tag, registries);
    }

    protected void loadData(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag researchPackUsageTag = tag.getCompound("research_pack_usage");
        for (String key : researchPackUsageTag.getAllKeys()) {
            this.researchPackUsage.put((ResourceKey<ResearchPack>)ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)ResourceLocation.parse((String)key)), Float.valueOf(researchPackUsageTag.getFloat(key)));
        }
        super.loadData(tag, registries);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Research Lab");
    }

    protected PDLAbstractContainerMenu<?> createControllerMenu(int containerId, Inventory inventory, Player player) {
        return new ResearchLabMenu(containerId, inventory, this);
    }
}

