/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.portingdeadmods.portingdeadlibs.utils.Result;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.compat.KubeJSCompat;
import com.portingdeadmods.researchd.compat.ResearchdCompatHandler;
import com.portingdeadmods.researchd.compat.kubejs.example.KubeJSExample;
import com.portingdeadmods.researchd.resources.ExampleDatapack;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.loading.FMLPaths;

public class ExampleCommands {
    public static LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"example").then(((LiteralArgumentBuilder)Commands.literal((String)"kubejs").requires(p -> KubeJSCompat.isKubeJSLoaded())).executes(ExampleCommands::createKubeJSExample))).then(((LiteralArgumentBuilder)Commands.literal((String)"datapack").executes(ExampleCommands::createDatapackExample)).then(((RequiredArgumentBuilder)Commands.argument((String)"pack-name", (ArgumentType)StringArgumentType.string()).executes(ExampleCommands::createDatapackExample)).then(Commands.argument((String)"pack-desc", (ArgumentType)StringArgumentType.string()).executes(ExampleCommands::createDatapackExample))))).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int createDatapackExample(CommandContext<CommandSourceStack> ctx) {
        String gameDirPath;
        String filePath;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String name = ExampleCommands.getArgOrDefault(ctx, "pack-name", String.class, "researchd_examples_pack");
        String description = ExampleCommands.getArgOrDefault(ctx, "pack-desc", String.class, "Auto-created researchd example pack");
        Result<Path, Exception> result = ExampleDatapack.createExample(((CommandSourceStack)ctx.getSource()).getServer().getWorldPath(LevelResource.DATAPACK_DIR), name, description);
        if (!(result instanceof Result.Ok)) {
            Exception error = (Exception)result.error();
            source.sendFailure((Component)Component.literal((String)"Failed to create example datapack: ").append(error.getMessage()).withStyle(ChatFormatting.RED));
            return 0;
        }
        Result.Ok ok = (Result.Ok)result;
        try {
            Path path;
            Path value = path = (Path)ok.value();
            filePath = value.toString();
            gameDirPath = FMLPaths.GAMEDIR.get().toString();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Researchd.LOGGER.debug("Game dir: {}, datapack: {}", (Object)gameDirPath, (Object)filePath);
        StringBuilder shortPath = new StringBuilder(filePath);
        shortPath.insert(0, "..");
        source.sendSuccess(() -> Component.literal((String)"Successfully created example datapack at ").append((Component)Component.literal((String)shortPath.toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open directory"))))).append((Component)Component.literal((String)" - (run '/datapack enable \"file/%s\"' to enable pack".formatted(name)).withStyle(ChatFormatting.GRAY)), true);
        source.getServer().getPackRepository().reload();
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int createKubeJSExample(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (ResearchdCompatHandler.isKubeJSLoaded()) {
            Result<Path, Exception> result = KubeJSExample.createExample();
            if (result instanceof Result.Ok) {
                StringBuilder shortPath;
                String filePath;
                Result.Ok ok = (Result.Ok)result;
                try {
                    Path path;
                    Path value = path = (Path)ok.value();
                    filePath = value.toString();
                    String gameDirPath = FMLPaths.GAMEDIR.get().normalize().toAbsolutePath().toString();
                    shortPath = new StringBuilder(filePath.substring(gameDirPath.length()));
                    shortPath.insert(0, "...");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                source.sendSuccess(() -> Component.literal((String)"Successfully created KubeJS example file at ").append((Component)Component.literal((String)shortPath.toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath.substring(0, filePath.length() - "research_examples.js".length()))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open containing directory"))))).append((Component)Component.literal((String)" - (run '/reload' for the example to work)").withStyle(ChatFormatting.GRAY)), true);
                return 1;
            }
            Exception error = (Exception)result.error();
            source.sendFailure((Component)Component.literal((String)"Failed to create KubeJS example file: ").append(error.getMessage()).withStyle(ChatFormatting.RED));
        }
        return 0;
    }

    private static <T> T getArgOrDefault(CommandContext<CommandSourceStack> ctx, String name, Class<T> clazz, T defaultValue) {
        Object value;
        try {
            value = ctx.getArgument(name, clazz);
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }
}

