/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.portingdeadmods.portingdeadlibs.utils.PlayerUtils;
import com.portingdeadmods.portingdeadlibs.utils.SuggestionUtils;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.utils.ResearchdSuggestionUtils;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeamCommands {
    public static LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"team").then(Commands.literal((String)"help").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ResearchTeamHelper.sendHelpMessage(arg_0 -> ((CommandSourceStack)source).sendSystemMessage(arg_0));
            return 1;
        }))).then(Commands.literal((String)"members").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeam team = ResearchTeamHelper.getTeamByMember((Player)player);
                player.sendSystemMessage(ResearchTeamHelper.formatMembers(team, player.level()));
            }
            return 1;
        }))).then(Commands.literal((String)"invite").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::playerNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeamHelper.handleSendInviteToPlayer(player, PlayerUtils.getPlayerUUIDFromName((Level)((CommandSourceStack)context.getSource()).getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"player")), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"leave").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeamHelper.handleLeaveTeam(player);
            }
            return 1;
        })).then(Commands.argument((String)"nextToLead", (ArgumentType)StringArgumentType.string()).suggests(ResearchdSuggestionUtils::teamMemberNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                if (StringArgumentType.getString((CommandContext)context, (String)"nextToLead").equals("none")) {
                    ResearchTeamHelper.handleLeaveTeam(player);
                } else {
                    ResearchTeamHelper.handleLeaveTeam(player, PlayerUtils.getPlayerUUIDFromName((Level)((CommandSourceStack)context.getSource()).getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"nextToLead")));
                }
            }
            return 1;
        })))).then(Commands.literal((String)"join").then(Commands.argument((String)"memberOfTeam", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::playerNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeamHelper.handleEnterTeam(player, PlayerUtils.getPlayerUUIDFromName((Level)((CommandSourceStack)context.getSource()).getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"memberOfTeam")));
            }
            return 1;
        })))).then(Commands.literal((String)"ignore").then(Commands.argument((String)"memberOfTeam", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::playerNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeamHelper.handleIgnoreTeam(player, PlayerUtils.getPlayerUUIDFromName((Level)((CommandSourceStack)context.getSource()).getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"memberOfTeam")));
            }
            return 1;
        })))).then(Commands.literal((String)"promote").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(ResearchdSuggestionUtils::teamMemberNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            Player otherPlayer = PlayerUtils.getPlayerFromName((Level)source.getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"player"));
            ServerLevel level = source.getLevel();
            if (player != null) {
                ResearchTeamHelper.handleManageModerator(player, otherPlayer.getUUID(), false);
            }
            return 1;
        })))).then(Commands.literal((String)"demote").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(ResearchdSuggestionUtils::teamMemberNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            Player otherPlayer = PlayerUtils.getPlayerFromName((Level)source.getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"player"));
            ServerLevel level = source.getLevel();
            if (player != null) {
                ResearchTeamHelper.handleManageModerator(player, otherPlayer.getUUID(), true);
            }
            return 1;
        })))).then(Commands.literal((String)"kick").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(ResearchdSuggestionUtils::teamMemberNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            Player otherPlayer = PlayerUtils.getPlayerFromName((Level)source.getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"player"));
            ServerLevel level = source.getLevel();
            if (player != null) {
                ResearchTeamHelper.handleManageMember(player, otherPlayer.getUUID(), true);
            }
            return 1;
        })))).then(Commands.literal((String)"transfer-ownership").then(Commands.argument((String)"nextToLead", (ArgumentType)StringArgumentType.string()).suggests(ResearchdSuggestionUtils::teamMemberNames).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                if (StringArgumentType.getString((CommandContext)context, (String)"nextToLead").equals("none")) {
                    source.sendSystemMessage((Component)ResearchTeamHelper.getIllegalMessage());
                } else {
                    ResearchTeamHelper.handleTransferOwnership(player, PlayerUtils.getPlayerUUIDFromName((Level)((CommandSourceStack)context.getSource()).getLevel(), (String)StringArgumentType.getString((CommandContext)context, (String)"nextToLead")));
                }
            }
            return 1;
        })))).then(Commands.literal((String)"set-name").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayer();
            if (player != null) {
                ResearchTeamHelper.handleSetName(player, StringArgumentType.getString((CommandContext)context, (String)"name"));
            }
            return 1;
        })))).build();
    }
}

