/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.data.components;

import com.mojang.serialization.Codec;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public record ResearchPackComponent(Optional<ResourceKey<ResearchPack>> researchPackKey) {
    public static final ResearchPackComponent EMPTY = new ResearchPackComponent(Optional.empty());
    public static final Codec<ResearchPackComponent> CODEC = ExtraCodecs.optionalEmptyMap((Codec)ResearchPackImpl.RESOURCE_KEY_CODEC).xmap(ResearchPackComponent::new, ResearchPackComponent::researchPackKey);
    public static final StreamCodec<? super RegistryFriendlyByteBuf, ResearchPackComponent> STREAM_CODEC = ByteBufCodecs.optional((StreamCodec)ResearchPackImpl.RESOURCE_KEY_STREAM_CODEC).map(ResearchPackComponent::new, ResearchPackComponent::researchPackKey);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Optional<ResourceKey<ResearchPack>> packKey;
        if (!(o instanceof ResearchPackComponent)) return false;
        ResearchPackComponent researchPackComponent = (ResearchPackComponent)o;
        try {
            Optional<ResourceKey<ResearchPack>> optional;
            packKey = optional = researchPackComponent.researchPackKey();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Objects.equals(this.researchPackKey, packKey);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.researchPackKey);
    }
}

