/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.datagen;

import com.portingdeadmods.researchd.datagen.BlockLootProvider;
import com.portingdeadmods.researchd.datagen.BlockModelProvider;
import com.portingdeadmods.researchd.datagen.EnUsLangProvider;
import com.portingdeadmods.researchd.datagen.RecipesProvider;
import com.portingdeadmods.researchd.datagen.TagsProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="researchd")
public class DataGatherer {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLangProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelProvider(output, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesProvider(output, lookupProvider));
        TagsProvider.createTagProviders(generator, output, lookupProvider, event.getExistingFileHelper(), event.includeServer());
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

