/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.datagen;

import com.portingdeadmods.researchd.ResearchdConfig;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import com.portingdeadmods.researchd.pdl.config.PDLConfigHelper;
import com.portingdeadmods.researchd.registries.ResearchdBlocks;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class EnUsLangProvider
extends LanguageProvider {
    public EnUsLangProvider(PackOutput output) {
        super(output, "researchd", "en_us");
    }

    protected void addTranslations() {
        ResearchdTranslations.init();
        for (Map.Entry<String, String> entry : ResearchdTranslations.TRANSLATIONS.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        this.addBlock((Supplier)ResearchdBlocks.RESEARCH_LAB_PART, "Research Lab Part");
        this.addBlock((Supplier)ResearchdBlocks.RESEARCH_LAB_CONTROLLER, "Research Lab");
        PDLConfigHelper.generateConfigNames(ResearchdConfig.Client.class, "researchd", (arg_0, arg_1) -> ((EnUsLangProvider)this).add(arg_0, arg_1));
        PDLConfigHelper.generateConfigNames(ResearchdConfig.Common.class, "researchd", (arg_0, arg_1) -> ((EnUsLangProvider)this).add(arg_0, arg_1));
    }

    private void addResearch(ResourceKey<Research> key, String name) {
        this.add(key.registry().getPath() + "." + key.location().getNamespace() + "." + key.location().getPath(), name);
    }

    private void addResearchDesc(ResourceKey<Research> key, String name) {
        this.add("research_desc." + key.location().getNamespace() + "." + key.location().getPath(), name);
    }

    private void addResearchMethod(ResourceLocation key, String name) {
        this.add("research_method." + key.getNamespace() + "." + key.getPath(), name);
    }

    private void addResearchPack(ResourceKey<ResearchPackImpl> key, String name) {
        this.add("item.researchd.research_pack_" + key.location().toString().replace(':', '_'), name);
    }

    private void addResearchPack(ResourceLocation key, String name) {
        this.add("item.researchd.research_pack_" + key.toString().replace(':', '_'), name);
    }
}

