/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.events;

import com.mojang.brigadier.CommandDispatcher;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.compat.KubeJSCompat;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.networking.research.ResearchCacheReloadPayload;
import com.portingdeadmods.researchd.networking.research.ResearchFinishedPayload;
import com.portingdeadmods.researchd.networking.research.ResearchProgressSyncPayload;
import com.portingdeadmods.researchd.registries.ResearchdCommands;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="researchd")
public final class ResearchdCommonEvents {
    @SubscribeEvent
    private static void entityPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            UUID uuid = player.getUUID();
            if (level.getBlockEntity(event.getPos()) != null) {
                level.getBlockEntity(event.getPos()).setData(ResearchdAttachments.PLACED_BY_UUID, (Object)uuid);
            }
        }
    }

    @SubscribeEvent
    private static void onCommandRegister(RegisterCommandsEvent event) {
        ResearchdCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        ServerLevel level = server.overworld();
        ResearchTeamMap teamMap = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
        if (teamMap != null) {
            if (level.getGameTime() % 20L == 0L) {
                ResearchdCommonEvents.handleResearchMethods((Level)level, teamMap);
            }
            for (ResearchTeam researchTeam : teamMap.researchTeams().values()) {
                ResourceKey<Research> research = researchTeam.getCurrentResearch();
                if (research == null) continue;
                ResourceKey<Research> currentResearchKey = researchTeam.getCurrentResearch();
                Research currentResearch = ResearchHelperCommon.getResearch(currentResearchKey, (Level)level);
                ResearchProgress currentResearchProgress = researchTeam.getCurrentProgress();
                if (currentResearchProgress != null) {
                    ServerPlayer player;
                    if (level.getGameTime() % 4L == 0L) {
                        for (TeamMember memberUUID : researchTeam.getMembers()) {
                            player = server.getPlayerList().getPlayer(memberUUID.player());
                            if (player == null) continue;
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ResearchProgressSyncPayload(researchTeam.getCurrentResearch(), currentResearchProgress), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                    if (currentResearchProgress.isComplete()) {
                        researchTeam.completeResearch(research, server.overworld().getDayTime() * 50L, (Level)level);
                        for (TeamMember playerUUIDs : researchTeam.getMembers()) {
                            player = server.getPlayerList().getPlayer(playerUUIDs.player());
                            if (player == null) continue;
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ResearchFinishedPayload(research, (int)server.overworld().getDayTime() * 50), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            KubeJSCompat.fireResearchCompletedEvent(player, research);
                            Researchd.debug("Researching", "Applying research effects for Research: " + String.valueOf(researchTeam.getCurrentResearch()) + " to player: " + player.getName().getString());
                            currentResearch.researchEffect().onUnlock((Level)level, (Player)player, researchTeam.getCurrentResearch());
                        }
                        researchTeam.getQueue().remove(0, false);
                    }
                }
                if (level.getGameTime() % 20L != 0L) continue;
                ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)teamMap);
            }
        }
    }

    public static void handleResearchMethods(Level level, ResearchTeamMap teamMap) {
        for (ResearchTeam researchTeam : teamMap.researchTeams().values()) {
            ResearchProgress rp;
            ResourceKey<Research> firstInQueue = researchTeam.getQueue().getFirst();
            if (firstInQueue == null || (rp = researchTeam.getResearchProgresses().get(firstInQueue)) == null) continue;
            rp.checkProgress(firstInQueue, level, new ResearchMethod.SimpleMethodContext(researchTeam, null));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            CommonResearchCache.initialize((Level)event.getLevel().getServer().overworld());
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        CommonResearchCache.reset();
    }

    @SubscribeEvent
    public static void onDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent event) {
        Level level = event.getEntity().level();
        if (!level.isClientSide()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ResearchCacheReloadPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinLevelEvent entity) {
        if (entity.getLevel().isClientSide()) {
            return;
        }
        Entity entity2 = entity.getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            ServerLevel level = player.serverLevel();
            ResearchTeamMap data = (ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)level);
            data.initPlayer(player);
            ResearchdSavedData.TEAM_RESEARCH.get().setData((Level)level, (Object)data);
            ResearchdSavedData.TEAM_RESEARCH.get().syncToPlayer(player);
        }
    }
}

