/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.api.research.RegistryDisplay;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffect;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchSerializer;
import com.portingdeadmods.researchd.impl.research.ItemResearchIcon;
import com.portingdeadmods.researchd.impl.research.effect.EmptyResearchEffect;
import com.portingdeadmods.researchd.impl.utils.DisplayImpl;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public final class SimpleResearch
extends Record
implements Research,
RegistryDisplay<Research> {
    private final ItemResearchIcon researchIcon;
    private final ResearchMethod researchMethod;
    private final ResearchEffect researchEffect;
    private final List<ResourceKey<Research>> parents;
    private final boolean requiresParent;
    private final DisplayImpl display;

    public SimpleResearch(ItemResearchIcon researchIcon, ResearchMethod researchMethod, ResearchEffect researchEffect, List<ResourceKey<Research>> parents, boolean requiresParent, DisplayImpl display) {
        this.researchIcon = researchIcon;
        this.researchMethod = researchMethod;
        this.researchEffect = researchEffect;
        this.parents = parents;
        this.requiresParent = requiresParent;
        this.display = display;
    }

    @Override
    public ResearchSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Component getDisplayName(ResourceKey<Research> key) {
        return this.display.name().orElse(Research.getLangName(key));
    }

    @Override
    public Component getDisplayDescription(ResourceKey<Research> key) {
        return this.display.desc().orElse(Research.getLangDesc(key));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleResearch.class, "researchIcon;researchMethod;researchEffect;parents;requiresParent;display", "researchIcon", "researchMethod", "researchEffect", "parents", "requiresParent", "display"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SimpleResearch.class, "researchIcon;researchMethod;researchEffect;parents;requiresParent;display", "researchIcon", "researchMethod", "researchEffect", "parents", "requiresParent", "display"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SimpleResearch.class, "researchIcon;researchMethod;researchEffect;parents;requiresParent;display", "researchIcon", "researchMethod", "researchEffect", "parents", "requiresParent", "display"}, this, o);
    }

    @Override
    public ItemResearchIcon researchIcon() {
        return this.researchIcon;
    }

    @Override
    public ResearchMethod researchMethod() {
        return this.researchMethod;
    }

    @Override
    public ResearchEffect researchEffect() {
        return this.researchEffect;
    }

    @Override
    public List<ResourceKey<Research>> parents() {
        return this.parents;
    }

    @Override
    public boolean requiresParent() {
        return this.requiresParent;
    }

    public DisplayImpl display() {
        return this.display;
    }

    public static class Serializer
    implements ResearchSerializer<SimpleResearch> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<SimpleResearch> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemResearchIcon.CODEC.fieldOf("icon").forGetter(SimpleResearch::researchIcon), (App)ResearchMethod.CODEC.fieldOf("method").forGetter(SimpleResearch::researchMethod), (App)ResearchEffect.CODEC.optionalFieldOf("effect", (Object)EmptyResearchEffect.INSTANCE).forGetter(SimpleResearch::researchEffect), (App)Research.RESOURCE_KEY_CODEC.listOf().fieldOf("parents").forGetter(SimpleResearch::parents), (App)Codec.BOOL.fieldOf("requires_parent").forGetter(SimpleResearch::requiresParent), (App)DisplayImpl.CODEC.optionalFieldOf("display", (Object)DisplayImpl.EMPTY).forGetter(SimpleResearch::display)).apply((Applicative)instance, SimpleResearch::new));
        public static final StreamCodec<? super RegistryFriendlyByteBuf, SimpleResearch> STREAM_CODEC = StreamCodec.composite(ItemResearchIcon.STREAM_CODEC, SimpleResearch::researchIcon, ResearchMethod.STREAM_CODEC, SimpleResearch::researchMethod, ResearchEffect.STREAM_CODEC, SimpleResearch::researchEffect, (StreamCodec)Research.RESOURCE_KEY_STREAM_CODEC.apply(ByteBufCodecs.list()), SimpleResearch::parents, (StreamCodec)ByteBufCodecs.BOOL, SimpleResearch::requiresParent, DisplayImpl.STREAM_CODEC, SimpleResearch::display, SimpleResearch::new);

        private Serializer() {
        }

        @Override
        public MapCodec<SimpleResearch> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, SimpleResearch> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Builder {
        private ItemResearchIcon icon = ItemResearchIcon.EMPTY;
        private ResearchMethod researchMethod;
        private ResearchEffect researchEffect = EmptyResearchEffect.INSTANCE;
        private final UniqueArray<ResourceKey<Research>> parents = new UniqueArray();
        private boolean requiresParent = false;
        private Optional<Component> literalName = Optional.empty();
        private Optional<Component> literalDescription = Optional.empty();

        private Builder() {
        }

        public Builder icon(Item icon) {
            this.icon = ItemResearchIcon.single((ItemLike)icon);
            return this;
        }

        public Builder icon(ItemResearchIcon icon) {
            this.icon = icon;
            return this;
        }

        public Builder method(ResearchMethod researchMethod) {
            this.researchMethod = researchMethod;
            return this;
        }

        public Builder effect(ResearchEffect researchEffect) {
            this.researchEffect = researchEffect;
            return this;
        }

        @SafeVarargs
        public final Builder parents(ResourceKey<Research> ... parents) {
            this.parents.addAll(List.of(parents));
            return this;
        }

        public Builder parents(Collection<ResourceKey<Research>> parents) {
            this.parents.addAll(parents);
            return this;
        }

        public Builder requiresParent(boolean requiresParent) {
            this.requiresParent = requiresParent;
            return this;
        }

        public Builder literalName(String name) {
            this.literalName = Optional.of(Component.literal((String)name));
            return this;
        }

        public Builder literalDescription(String description) {
            this.literalDescription = Optional.of(Component.literal((String)description));
            return this;
        }

        public Builder literalName(Component name) {
            this.literalName = Optional.of(name);
            return this;
        }

        public Builder literalDescription(Component description) {
            this.literalDescription = Optional.of(description);
            return this;
        }

        public SimpleResearch build() {
            return new SimpleResearch(this.icon, this.researchMethod, this.researchEffect, (List<ResourceKey<Research>>)this.parents, this.requiresParent, new DisplayImpl(this.literalName, this.literalDescription));
        }
    }
}

