/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.ResearchdConfig;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.team.ResearchQueue;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public record SimpleResearchQueue(List<ResourceKey<Research>> entries) implements ResearchQueue
{
    public static final SimpleResearchQueue EMPTY = new SimpleResearchQueue(new ArrayList<ResourceKey<Research>>());
    public static final Codec<SimpleResearchQueue> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Research.RESOURCE_KEY_CODEC.listOf().fieldOf("entries").forGetter(SimpleResearchQueue::entries)).apply((Applicative)inst, SimpleResearchQueue::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleResearchQueue> STREAM_CODEC = StreamCodec.composite((StreamCodec)Research.RESOURCE_KEY_STREAM_CODEC.apply(ByteBufCodecs.list()), SimpleResearchQueue::entries, SimpleResearchQueue::new);
    public static final IntSupplier QUEUE_LENGTH = () -> ResearchdConfig.Common.researchQueueLength;

    public SimpleResearchQueue(List<ResourceKey<Research>> entries) {
        this.entries = new ArrayList<ResourceKey<Research>>(entries);
    }

    public SimpleResearchQueue() {
        this(new ArrayList<ResourceKey<Research>>(QUEUE_LENGTH.getAsInt()));
    }

    @Override
    public boolean add(ResearchInstance researchInstance) {
        if (researchInstance.getResearchStatus() == ResearchStatus.RESEARCHED) {
            return false;
        }
        for (ResourceKey<Research> instance : this.entries) {
            if (!instance.equals(researchInstance.getKey())) continue;
            return false;
        }
        if (this.entries.size() < QUEUE_LENGTH.getAsInt()) {
            this.entries.add(researchInstance.getKey());
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(ResourceKey<Research> researchKey, boolean removeChildren) {
        return this.remove(this.entries.indexOf(researchKey), removeChildren);
    }

    @Override
    public boolean remove(int index, boolean removeChildren) {
        if (this.entries.size() > index && index >= 0) {
            if (removeChildren) {
                for (ResourceKey child : CommonResearchCache.allChildrenOf(this.entries.get(index)).stream().map(GlobalResearch::getResearchKey).toList()) {
                    this.remove(this.entries.indexOf(child), true);
                }
            }
            for (int i = index; i < this.entries.size(); ++i) {
                if (i + 1 >= this.entries.size()) continue;
                this.entries.set(i, this.entries.get(i + 1));
            }
            this.entries.removeLast();
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ResourceKey<Research> research) {
        return this.entries.contains(research);
    }

    @Override
    public ResourceKey<Research> get(int index) {
        return this.entries.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public ResourceKey<Research> getFirst() {
        return this.entries.isEmpty() ? null : this.entries.getFirst();
    }

    @Nullable
    public ResourceKey<Research> current() {
        return this.entries.isEmpty() ? null : this.entries.getFirst();
    }

    @Override
    public int size() {
        return this.entries.size();
    }
}

