/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.effect.data;

import com.mojang.serialization.Codec;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectData;
import com.portingdeadmods.researchd.impl.research.effect.RecipeUnlockEffect;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.Collection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public record RecipeUnlockEffectData(UniqueArray<ResourceLocation> blockedRecipes) implements ResearchEffectData<RecipeUnlockEffect>
{
    public static final RecipeUnlockEffectData EMPTY = new RecipeUnlockEffectData((UniqueArray<ResourceLocation>)new UniqueArray());
    public static final Codec<RecipeUnlockEffectData> CODEC = UniqueArray.CODEC((Codec)ResourceLocation.CODEC).xmap(RecipeUnlockEffectData::new, RecipeUnlockEffectData::blockedRecipes);
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeUnlockEffectData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UniqueArray.STREAM_CODEC((StreamCodec)ResourceLocation.STREAM_CODEC), RecipeUnlockEffectData::blockedRecipes, RecipeUnlockEffectData::new);

    public RecipeUnlockEffectData add(RecipeUnlockEffect recipe, Level level) {
        UniqueArray recipes = new UniqueArray(this.blockedRecipes());
        recipe.getRecipes(level).forEach(holder -> recipes.add((Object)holder.id()));
        return new RecipeUnlockEffectData((UniqueArray<ResourceLocation>)recipes);
    }

    public RecipeUnlockEffectData remove(RecipeUnlockEffect recipe, Level level) {
        UniqueArray recipes = new UniqueArray(this.blockedRecipes());
        recipe.getRecipes(level).forEach(holder -> recipes.remove((Object)holder.id()));
        return new RecipeUnlockEffectData((UniqueArray<ResourceLocation>)recipes);
    }

    public boolean contains(ResourceLocation recipeId) {
        return this.blockedRecipes.contains((Object)recipeId);
    }

    public boolean contains(RecipeHolder<?> holder) {
        return this.contains(holder.id());
    }

    public boolean isEmpty() {
        return this.blockedRecipes.isEmpty();
    }

    public UniqueArray<RecipeHolder<?>> resolve(Level level) {
        UniqueArray resolved = new UniqueArray();
        for (ResourceLocation id : this.blockedRecipes()) {
            level.getRecipeManager().byKey(id).ifPresent(arg_0 -> ((UniqueArray)resolved).add(arg_0));
        }
        return resolved;
    }

    @Override
    public UniqueArray<ResourceLocation> getAll() {
        return this.blockedRecipes();
    }

    public RecipeUnlockEffectData getDefault(Level level) {
        Collection<RecipeUnlockEffect> recipeEffects = ResearchHelperCommon.getResearchEffects(RecipeUnlockEffect.class, level);
        UniqueArray blocked = new UniqueArray();
        for (RecipeUnlockEffect unlock : recipeEffects) {
            unlock.getRecipes(level).forEach(holder -> blocked.add((Object)holder.id()));
        }
        return new RecipeUnlockEffectData((UniqueArray<ResourceLocation>)blocked);
    }
}

