/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.effect.data;

import com.mojang.serialization.Codec;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectData;
import com.portingdeadmods.researchd.impl.research.effect.UnlockItemEffect;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record UnlockItemEffectData(UniqueArray<ResourceKey<Item>> blockedItems) implements ResearchEffectData<UnlockItemEffect>
{
    public static final UnlockItemEffectData EMPTY = new UnlockItemEffectData((UniqueArray<ResourceKey<Item>>)new UniqueArray());
    public static final Codec<UnlockItemEffectData> CODEC = UniqueArray.CODEC((Codec)ResourceKey.codec((ResourceKey)Registries.ITEM)).xmap(UnlockItemEffectData::new, UnlockItemEffectData::blockedItems);
    public static final StreamCodec<ByteBuf, UnlockItemEffectData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UniqueArray.STREAM_CODEC((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ITEM)), UnlockItemEffectData::blockedItems, UnlockItemEffectData::new);

    public UnlockItemEffectData add(UnlockItemEffect effect, Level level) {
        UniqueArray items = new UniqueArray(this.blockedItems());
        items.add(effect.getItemKey());
        return new UnlockItemEffectData((UniqueArray<ResourceKey<Item>>)items);
    }

    public UnlockItemEffectData remove(UnlockItemEffect effect, Level level) {
        UniqueArray items = new UniqueArray(this.blockedItems());
        items.remove(effect.getItemKey());
        return new UnlockItemEffectData((UniqueArray<ResourceKey<Item>>)items);
    }

    public boolean isBlocked(ItemStack stack) {
        return this.isBlocked(stack.getItem());
    }

    public boolean isBlocked(Item item) {
        return this.blockedItems.contains((Object)item.builtInRegistryHolder().key());
    }

    public UnlockItemEffectData getDefault(Level level) {
        Collection<UnlockItemEffect> unlockItemEffects = ResearchHelperCommon.getResearchEffects(UnlockItemEffect.class, level);
        UniqueArray blockedItems = new UniqueArray();
        for (UnlockItemEffect effect : unlockItemEffects) {
            blockedItems.add(effect.getItemKey());
        }
        return new UnlockItemEffectData((UniqueArray<ResourceKey<Item>>)blockedItems);
    }

    @Override
    public UniqueArray<ResourceKey<Item>> getAll() {
        return this.blockedItems();
    }
}

