/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.method;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchMethodSerializer;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import java.util.Iterator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record CheckItemPresenceResearchMethod(Ingredient target, int count) implements ResearchMethod
{
    public static final CheckItemPresenceResearchMethod EMPTY = new CheckItemPresenceResearchMethod(Ingredient.EMPTY, 0);
    public static final ResourceLocation ID = Researchd.rl("check_item_presence");

    @Override
    public void checkProgress(Level level, ResourceKey<Research> research, ResearchProgress.Task task, ResearchMethod.MethodContext context) {
        TeamMember member;
        Player player;
        if (this.count <= 0 || this.target == Ingredient.EMPTY) {
            task.addProgress(this.getMaxProgress() - task.getProgress());
            return;
        }
        int totalFound = 0;
        Iterator iterator = context.team().getMembers().iterator();
        while (iterator.hasNext() && ((player = level.getPlayerByUUID((member = (TeamMember)iterator.next()).player())) == null || (totalFound += this.countMatchingItems(player)) < this.count)) {
        }
        float targetProgress = Math.min(1.0f, (float)totalFound / (float)this.count) * this.getMaxProgress();
        float delta = targetProgress - task.getProgress();
        if (delta > 0.0f) {
            task.addProgress(delta);
        }
    }

    private int countMatchingItems(Player player) {
        int matches = 0;
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (!this.target.test(stack)) continue;
            matches += stack.getCount();
        }
        return matches;
    }

    @Override
    public float getMaxProgress() {
        return 1.0f;
    }

    @Override
    public ResearchProgress createProgress() {
        return ResearchProgress.single(this);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements ResearchMethodSerializer<CheckItemPresenceResearchMethod> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<CheckItemPresenceResearchMethod> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("item").forGetter(CheckItemPresenceResearchMethod::target), (App)Codec.INT.fieldOf("count").forGetter(CheckItemPresenceResearchMethod::count)).apply((Applicative)instance, CheckItemPresenceResearchMethod::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CheckItemPresenceResearchMethod> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CheckItemPresenceResearchMethod::target, (StreamCodec)ByteBufCodecs.INT, CheckItemPresenceResearchMethod::count, CheckItemPresenceResearchMethod::new);

        private Serializer() {
        }

        @Override
        @NotNull
        public MapCodec<CheckItemPresenceResearchMethod> codec() {
            return CODEC;
        }

        @Override
        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CheckItemPresenceResearchMethod> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

