/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.method;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.serializers.ResearchMethodSerializer;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ConsumeItemResearchMethod(Ingredient toConsume, int count) implements ResearchMethod
{
    public static final ConsumeItemResearchMethod EMPTY = new ConsumeItemResearchMethod(Ingredient.EMPTY, 0);
    public static final ResourceLocation ID = Researchd.rl("consume_item");

    @Override
    public void checkProgress(Level level, ResourceKey<Research> research, ResearchProgress.Task task, ResearchMethod.MethodContext context) {
        ArrayList<ItemStack> matchingItems = new ArrayList<ItemStack>(8);
        int remaining = this.count() - (int)task.getProgress();
        int found = 0;
        block0: for (TeamMember member : context.team().getMembers()) {
            Player player = level.getPlayerByUUID(member.player());
            if (player == null) continue;
            int containerSize = player.getInventory().getContainerSize();
            for (int i = 0; i < containerSize; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!this.toConsume.test(stack)) continue;
                matchingItems.add(stack);
                found = Math.min(remaining, found + stack.getCount());
                if (found == remaining) break block0;
            }
        }
        task.addProgress(found);
        matchingItems.sort(Comparator.comparingInt(ItemStack::getCount).reversed());
        for (ItemStack stack : matchingItems) {
            int size = stack.getCount();
            int reduction = Math.min(found, size);
            stack.shrink(reduction);
            if ((found -= reduction) != 0) continue;
            return;
        }
    }

    @Override
    public float getMaxProgress() {
        return this.count();
    }

    @Override
    public ResearchProgress createProgress() {
        return ResearchProgress.single(this);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements ResearchMethodSerializer<ConsumeItemResearchMethod> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ConsumeItemResearchMethod> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("item").forGetter(ConsumeItemResearchMethod::toConsume), (App)Codec.INT.fieldOf("count").forGetter(ConsumeItemResearchMethod::count)).apply((Applicative)instance, ConsumeItemResearchMethod::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConsumeItemResearchMethod> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ConsumeItemResearchMethod::toConsume, (StreamCodec)ByteBufCodecs.INT, ConsumeItemResearchMethod::count, ConsumeItemResearchMethod::new);

        private Serializer() {
        }

        @Override
        @NotNull
        public MapCodec<ConsumeItemResearchMethod> codec() {
            return CODEC;
        }

        @Override
        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ConsumeItemResearchMethod> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

