/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.research.method;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.api.research.serializers.ResearchMethodSerializer;
import com.portingdeadmods.researchd.api.team.ValueEffectsHolder;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.research.ResearchPackImpl;
import com.portingdeadmods.researchd.registries.ResearchdValueEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ConsumePackResearchMethod(List<ResourceKey<ResearchPack>> packs, int count, int duration) implements ResearchMethod
{
    public static final ResourceLocation ID = Researchd.rl("consume_pack");

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void checkProgress(Level level, ResourceKey<Research> research, ResearchProgress.Task task, ResearchMethod.MethodContext context) {
        block7: {
            if (context instanceof ResearchMethod.SimpleMethodContext) {
                Object object;
                ResearchMethod.SimpleMethodContext simpleMethodContext = (ResearchMethod.SimpleMethodContext)context;
                try {
                    object = simpleMethodContext.team();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (object instanceof ValueEffectsHolder) {
                    ValueEffectsHolder team = (ValueEffectsHolder)object;
                    Object blockEntity = object = simpleMethodContext.blockEntity();
                    if (blockEntity == null) break block7;
                    List<ResourceKey<ResearchPack>> packs = this.packs();
                    ((ResearchLabControllerBE)((Object)blockEntity)).currentResearchDuration = this.duration();
                    if (!((ResearchLabControllerBE)((Object)blockEntity)).containsNecessaryPacks(packs)) {
                        return;
                    }
                    ((ResearchLabControllerBE)((Object)blockEntity)).decreaseNecessaryPackCount(packs);
                    for (ResourceKey<ResearchPack> pack : packs) {
                        ((ResearchLabControllerBE)((Object)blockEntity)).researchPackUsage.put(pack, Float.valueOf(Math.max(((ResearchLabControllerBE)((Object)blockEntity)).researchPackUsage.get(pack).floatValue() - 1.0f / (float)((ResearchLabControllerBE)((Object)blockEntity)).currentResearchDuration / team.getEffectValue(ResearchdValueEffects.RESEARCH_LAB_PRODUCTIVITY), 0.0f)));
                    }
                    task.addProgress(1.0f / (float)((ResearchLabControllerBE)((Object)blockEntity)).currentResearchDuration);
                }
            }
        }
    }

    @Override
    public boolean shouldCheckProgress() {
        return false;
    }

    @Override
    public float getMaxProgress() {
        return this.count;
    }

    @Override
    public ResearchProgress createProgress() {
        return ResearchProgress.single(this);
    }

    public List<ItemStack> asStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ResourceKey<ResearchPack> pack : this.packs) {
            ItemStack stack = ResearchPackImpl.asStack(pack);
            stacks.add(stack);
        }
        return stacks;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements ResearchMethodSerializer<ConsumePackResearchMethod> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ConsumePackResearchMethod> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResearchPackImpl.RESOURCE_KEY_CODEC).fieldOf("packs").forGetter(ConsumePackResearchMethod::packs), (App)Codec.INT.fieldOf("count").forGetter(ConsumePackResearchMethod::count), (App)Codec.INT.fieldOf("duration").forGetter(ConsumePackResearchMethod::duration)).apply((Applicative)instance, ConsumePackResearchMethod::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConsumePackResearchMethod> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(ResearchdRegistries.RESEARCH_PACK_KEY).apply(ByteBufCodecs.list()), ConsumePackResearchMethod::packs, (StreamCodec)ByteBufCodecs.INT, ConsumePackResearchMethod::count, (StreamCodec)ByteBufCodecs.INT, ConsumePackResearchMethod::duration, ConsumePackResearchMethod::new);

        private Serializer() {
        }

        @Override
        @NotNull
        public MapCodec<ConsumePackResearchMethod> codec() {
            return CODEC;
        }

        @Override
        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ConsumePackResearchMethod> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

