/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.team;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.cache.AllPlayersCache;
import com.portingdeadmods.portingdeadlibs.utils.LazyFinal;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.ValueEffect;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.team.ResearchQueue;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.api.team.ResearchTeamRole;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.api.team.TeamSocialManager;
import com.portingdeadmods.researchd.api.team.ValueEffectsHolder;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.team.SimpleTeamSocialManager;
import com.portingdeadmods.researchd.impl.team.TeamResearches;
import com.portingdeadmods.researchd.utils.ResearchdCodecUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SimpleResearchTeam
implements ResearchTeam,
ValueEffectsHolder {
    public static final GameProfile DEBUG_MEMBER = new GameProfile(UUID.fromString("b7c3f3ac-09b3-4e3c-b788-6f30594b34c6"), "Test player");
    private String name;
    private final UUID id;
    private final LazyFinal<Long> creationTime;
    private final LinkedHashMap<UUID, TeamMember> members;
    private final SimpleTeamSocialManager socialManager;
    private final TeamResearches researches;
    private final Map<ResourceLocation, Float> effects;
    public static final Codec<SimpleResearchTeam> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(SimpleResearchTeam::getName), (App)UUIDUtil.CODEC.fieldOf("id").forGetter(SimpleResearchTeam::getId), (App)Codec.unboundedMap((Codec)Codec.STRING, TeamMember.CODEC).fieldOf("members").forGetter(t -> ResearchdCodecUtils.encodeMap(t.members)), (App)SimpleTeamSocialManager.CODEC.fieldOf("sent_invites").forGetter(t -> t.socialManager), (App)TeamResearches.CODEC.fieldOf("researchPacks").forGetter(t -> t.researches), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).fieldOf("effects").forGetter(t -> ResearchdCodecUtils.encodeMap(t.effects))).apply((Applicative)builder, SimpleResearchTeam::newTeamStringMaps));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleResearchTeam> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SimpleResearchTeam::getName, (StreamCodec)UUIDUtil.STREAM_CODEC, t -> t.id, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, TeamMember.STREAM_CODEC), t -> t.members, SimpleTeamSocialManager.STREAM_CODEC, t -> t.socialManager, TeamResearches.STREAM_CODEC, t -> t.researches, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.FLOAT), t -> t.effects, SimpleResearchTeam::new);

    @NotNull
    private static SimpleResearchTeam newTeamStringMaps(String n, UUID i, Map<String, TeamMember> m, SimpleTeamSocialManager socialManager, TeamResearches tr, Map<String, Float> e) {
        return new SimpleResearchTeam(n, i, ResearchdCodecUtils.decodeMap(m, UUID::fromString), socialManager, tr, ResearchdCodecUtils.decodeMap(e, ResourceLocation::parse));
    }

    private SimpleResearchTeam(String name, UUID id, Map<UUID, TeamMember> members, SimpleTeamSocialManager socialManager, TeamResearches teamResearches, Map<ResourceLocation, Float> effects) {
        this.name = name;
        this.id = id;
        this.creationTime = LazyFinal.create();
        this.members = new LinkedHashMap<UUID, TeamMember>(members);
        this.socialManager = socialManager;
        this.researches = teamResearches;
        this.effects = effects;
    }

    private SimpleResearchTeam(UUID uuid, String name) {
        this(name, UUID.randomUUID(), Map.of(uuid, new TeamMember(uuid, ResearchTeamRole.OWNER)), SimpleTeamSocialManager.EMPTY, TeamResearches.EMPTY, new HashMap<ResourceLocation, Float>());
    }

    public static SimpleResearchTeam createDefaultTeam(UUID player, Level level) {
        Researchd.debug("Research Team", "Creating default team for player: " + AllPlayersCache.getName((UUID)player));
        SimpleResearchTeam team = new SimpleResearchTeam(player, AllPlayersCache.getName((UUID)player) + "'s Team");
        team.setCreationTime(level.getGameTime() * 50L);
        team.init(level);
        return team;
    }

    public static SimpleResearchTeam createDefaultTeam(ServerPlayer player) {
        return SimpleResearchTeam.createDefaultTeam(player.getUUID(), player.level());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public TeamMember getOwner() {
        for (TeamMember member : this.members.values()) {
            if (member.role() != ResearchTeamRole.OWNER) continue;
            return member;
        }
        return null;
    }

    @Override
    public SequencedCollection<TeamMember> getMembers() {
        return new LinkedList<TeamMember>(this.members.sequencedValues());
    }

    @Override
    public int getMembersAmount() {
        return this.members.size();
    }

    @Override
    @NotNull
    public TeamMember getMember(UUID uuid) {
        TeamMember member = this.members.get(uuid);
        if (member == null) {
            return new TeamMember(uuid, ResearchTeamRole.NOT_MEMBER);
        }
        return member;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime.initialize((Object)creationTime);
    }

    @Override
    public long getCreationTime() {
        return (Long)this.creationTime.getOrDefault((Object)0L);
    }

    @Override
    public ResearchQueue getQueue() {
        return this.researches.researchQueue();
    }

    @Override
    public Map<ResourceKey<Research>, ResearchInstance> getResearches() {
        return this.researches.researches();
    }

    @Override
    public Map<ResourceKey<Research>, ResearchProgress> getResearchProgresses() {
        return this.researches.progress();
    }

    @Override
    public void completeResearch(ResourceKey<Research> research, long completionTime, Level level) {
        this.researches.completeResearch(research, completionTime, level);
    }

    @Override
    public void refreshResearchStatus() {
        this.researches.refreshResearchStatus();
    }

    @Override
    public void addMember(UUID uuid) {
        this.members.put(uuid, new TeamMember(uuid, ResearchTeamRole.MEMBER));
    }

    @Override
    public void removeMember(UUID uuid) {
        this.members.remove(uuid);
    }

    @Override
    public void setRole(UUID member, ResearchTeamRole role) {
        this.members.put(member, new TeamMember(member, role));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean hasMember(UUID uuid) {
        return this.members.containsKey(uuid);
    }

    @Override
    public void addMember(UUID member, ResearchTeamRole role) {
        this.members.put(member, new TeamMember(member, role));
    }

    @Override
    public boolean isOwner(UUID uuid) {
        return this.members.containsKey(uuid) && this.members.get(uuid).role() == ResearchTeamRole.OWNER;
    }

    @Override
    public TeamSocialManager getSocialManager() {
        return this.socialManager;
    }

    @Override
    public boolean isModerator(UUID uuid) {
        TeamMember member = this.members.get(uuid);
        return member != null && member.role() == ResearchTeamRole.MODERATOR;
    }

    @Override
    public float getEffectValue(ValueEffect effect) {
        return this.effects.computeIfAbsent(ResearchdRegistries.VALUE_EFFECT.getKey((Object)effect), k -> Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public void setEffectValue(ValueEffect effect, float value) {
        this.effects.put(ResearchdRegistries.VALUE_EFFECT.getKey((Object)effect), Float.valueOf(value));
    }

    public void init(Level level) {
        Map<ResourceKey, ResearchInstance> researchInstances = CommonResearchCache.globalResearches.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<ResourceKey, ResearchInstance>((ResourceKey)e.getKey(), new ResearchInstance((GlobalResearch)e.getValue(), CommonResearchCache.rootResearch.is((ResourceKey<Research>)((ResourceKey)e.getKey())) ? ResearchStatus.RESEARCHABLE : ResearchStatus.LOCKED))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.getResearches().putAll(researchInstances);
        HashMap<ResourceKey<Research>, ResearchProgress> rps = new HashMap<ResourceKey<Research>, ResearchProgress>();
        for (ResourceKey<Research> key : CommonResearchCache.globalResearches.keySet()) {
            rps.put(key, ResearchProgress.forResearch(key, level));
        }
        this.getResearchProgresses().putAll(rps);
    }

    public TeamResearches getTeamResearches() {
        return this.researches;
    }
}

