/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.impl.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.research.SimpleResearchQueue;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record TeamResearches(SimpleResearchQueue researchQueue, HashMap<ResourceKey<Research>, ResearchInstance> researches, HashMap<ResourceKey<Research>, ResearchProgress> progress) {
    public static final TeamResearches EMPTY = new TeamResearches(new SimpleResearchQueue(), new HashMap<ResourceKey<Research>, ResearchInstance>(), new HashMap<ResourceKey<Research>, ResearchProgress>());
    public static final Codec<TeamResearches> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SimpleResearchQueue.CODEC.fieldOf("researchQueue").forGetter(TeamResearches::researchQueue), (App)Codec.unboundedMap(Research.RESOURCE_KEY_CODEC, ResearchInstance.CODEC).xmap(HashMap::new, Function.identity()).fieldOf("researchPacks").forGetter(TeamResearches::researches), (App)Codec.unboundedMap(Research.RESOURCE_KEY_CODEC, ResearchProgress.CODEC).xmap(HashMap::new, Function.identity()).fieldOf("completionProgress").forGetter(TeamResearches::progress)).apply((Applicative)instance, TeamResearches::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeamResearches> STREAM_CODEC = StreamCodec.composite(SimpleResearchQueue.STREAM_CODEC, TeamResearches::researchQueue, (StreamCodec)ByteBufCodecs.map(HashMap::new, Research.RESOURCE_KEY_STREAM_CODEC, ResearchInstance.STREAM_CODEC), TeamResearches::researches, (StreamCodec)ByteBufCodecs.map(HashMap::new, Research.RESOURCE_KEY_STREAM_CODEC, ResearchProgress.STREAM_CODEC), TeamResearches::progress, TeamResearches::new);

    public boolean hasCompleted(ResourceKey<Research> research) {
        return this.researches.get(research).getResearchStatus() == ResearchStatus.RESEARCHED;
    }

    public <T extends ResearchMethod> ResearchProgress getProgress(ResourceKey<Research> research) {
        return this.progress().get(research);
    }

    @Nullable
    public ResourceKey<Research> currentResearch() {
        return this.researchQueue.current();
    }

    public void refreshResearchStatus() {
        for (ResearchInstance instance : this.researches.values()) {
            if (instance.getResearchStatus() == ResearchStatus.RESEARCHED) continue;
            if (instance.getParents().stream().allMatch(parent -> this.hasCompleted(parent.getResearchKey()))) {
                instance.setResearchStatus(ResearchStatus.RESEARCHABLE);
                continue;
            }
            if (instance.getParents().stream().allMatch(parent -> {
                if (this.hasCompleted(parent.getResearchKey())) {
                    return true;
                }
                return this.researchQueue.entries().contains(parent.getResearchKey());
            })) {
                instance.setResearchStatus(ResearchStatus.RESEARCHABLE_AFTER_QUEUE);
                continue;
            }
            instance.setResearchStatus(ResearchStatus.LOCKED);
        }
    }

    public void completeResearch(ResourceKey<Research> research, long completionTime, Level level) {
        this.researches.get(research).setResearchStatus(ResearchStatus.RESEARCHED).setResearchedTime(completionTime);
        this.refreshResearchStatus();
    }
}

